/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.CCI_I22_MEDICATION_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v281.segment.RXC;
import ca.uhn.hl7v2.model.v281.segment.RXO;
import ca.uhn.hl7v2.model.v281.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCI_I22_MEDICATION_ORDER_DETAIL
extends AbstractGroup {
    public CCI_I22_MEDICATION_ORDER_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXO.class, true, false, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
            this.add(CCI_I22_MEDICATION_ORDER_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCI_I22_MEDICATION_ORDER_DETAIL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public RXO getRXO() {
        RXO retVal = (RXO)this.getTyped("RXO", RXO.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = (RXC)this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = (RXC)this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public CCI_I22_MEDICATION_ORDER_OBSERVATION getMEDICATION_ORDER_OBSERVATION() {
        CCI_I22_MEDICATION_ORDER_OBSERVATION retVal = (CCI_I22_MEDICATION_ORDER_OBSERVATION)this.getTyped("MEDICATION_ORDER_OBSERVATION", CCI_I22_MEDICATION_ORDER_OBSERVATION.class);
        return retVal;
    }

    public CCI_I22_MEDICATION_ORDER_OBSERVATION getMEDICATION_ORDER_OBSERVATION(int rep) {
        CCI_I22_MEDICATION_ORDER_OBSERVATION retVal = (CCI_I22_MEDICATION_ORDER_OBSERVATION)this.getTyped("MEDICATION_ORDER_OBSERVATION", rep, CCI_I22_MEDICATION_ORDER_OBSERVATION.class);
        return retVal;
    }

    public int getMEDICATION_ORDER_OBSERVATIONReps() {
        return this.getReps("MEDICATION_ORDER_OBSERVATION");
    }

    public List<CCI_I22_MEDICATION_ORDER_OBSERVATION> getMEDICATION_ORDER_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_ORDER_OBSERVATION", CCI_I22_MEDICATION_ORDER_OBSERVATION.class);
    }

    public void insertMEDICATION_ORDER_OBSERVATION(CCI_I22_MEDICATION_ORDER_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_ORDER_OBSERVATION", (Structure)structure, rep);
    }

    public CCI_I22_MEDICATION_ORDER_OBSERVATION insertMEDICATION_ORDER_OBSERVATION(int rep) throws HL7Exception {
        return (CCI_I22_MEDICATION_ORDER_OBSERVATION)super.insertRepetition("MEDICATION_ORDER_OBSERVATION", rep);
    }

    public CCI_I22_MEDICATION_ORDER_OBSERVATION removeMEDICATION_ORDER_OBSERVATION(int rep) throws HL7Exception {
        return (CCI_I22_MEDICATION_ORDER_OBSERVATION)super.removeRepetition("MEDICATION_ORDER_OBSERVATION", rep);
    }
}

