/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio;

import com.google.common.io.ByteStreams;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.tesla.proviso.archive.UnArchiver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SimpleProvisioner {
    public static final String DEFAULT_REMOTE_REPO = "https://repo1.maven.org/maven2";
    public static final File DEFAULT_LOCAL_REPO = new File(System.getProperty("user.home"), ".m2/repository");
    protected final UnArchiver unarchiver;
    protected final File localRepository;
    protected final String remoteRepositoryUrl;

    public SimpleProvisioner() {
        this(DEFAULT_LOCAL_REPO, DEFAULT_REMOTE_REPO);
    }

    public SimpleProvisioner(File localRepository, String remoteRepository) {
        this.localRepository = localRepository;
        this.remoteRepositoryUrl = remoteRepository;
        this.unarchiver = UnArchiver.builder().useRoot(false).flatten(false).build();
    }

    protected File resolveFromRepository(String coordinate) throws IOException {
        return this.resolveFromRepository(this.remoteRepositoryUrl, coordinate);
    }

    protected File resolveFromRepository(String repositoryUrl, String coordinate) throws IOException {
        String serverUrl = repositoryUrl == null ? this.remoteRepositoryUrl : repositoryUrl;
        String path = this.coordinateToPath(coordinate);
        String url = String.format("%s/%s", serverUrl, path);
        return this.resolveFromServer(url, coordinate);
    }

    protected File resolveFromServer(String archiveUrl, String coordinate) throws IOException {
        Request request;
        OkHttpClient client;
        Response response;
        String path = this.coordinateToPath(coordinate);
        File file = new File(this.localRepository, path);
        if (file.exists()) {
            return file;
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!(response = (client = new OkHttpClient()).newCall(request = new Request.Builder().url(archiveUrl).build()).execute()).isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try (FileOutputStream os = new FileOutputStream(file);){
            ByteStreams.copy((InputStream)response.body().byteStream(), (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    protected String coordinateToPath(String coords) {
        Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
        Matcher m = p.matcher(coords);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String extension = this.get(m.group(4), "jar");
        String classifier = this.get(m.group(6), "");
        String version = m.group(7);
        return this.repositoryPathOf(groupId, artifactId, extension, classifier, version);
    }

    protected String get(String value, String defaultValue) {
        return value == null || value.length() <= 0 ? defaultValue : value;
    }

    protected String repositoryPathOf(String groupId, String artifactId, String extension, String classifier, String version) {
        StringBuffer path = new StringBuffer().append(groupId.replace('.', '/')).append('/').append(artifactId).append('/').append(version).append('/').append(artifactId).append('-').append(version);
        if (classifier != null && !classifier.isEmpty() && !classifier.equals("jar")) {
            path.append("-").append(classifier);
        }
        path.append('.').append(extension);
        return path.toString();
    }
}

