/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.action.artifact;

import ca.vanzyl.provisio.action.artifact.filter.MustacheFilteringProcessor;
import ca.vanzyl.provisio.action.artifact.filter.StandardFilteringProcessor;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.ProvisioningContext;
import io.tesla.proviso.archive.UnArchiver;
import io.tesla.proviso.archive.UnarchivingEntryProcessor;
import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;

@Named(value="unpack")
public class UnpackAction
implements ProvisioningAction {
    private String includes;
    private String excludes;
    private boolean useRoot;
    private boolean flatten;
    private boolean filter;
    private boolean dereferenceHardlinks;
    private boolean mustache;
    private ProvisioArtifact artifact;
    private File outputDirectory;

    public void execute(ProvisioningContext context) {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File archive = this.artifact.getFile();
        try {
            UnArchiver unarchiver = UnArchiver.builder().includes(this.split(this.includes)).excludes(this.split(this.excludes)).useRoot(this.useRoot).flatten(this.flatten).dereferenceHardlinks(this.dereferenceHardlinks).build();
            if (this.filter) {
                unarchiver.unarchive(archive, this.outputDirectory, (UnarchivingEntryProcessor)new StandardFilteringProcessor(context.getVariables()));
            } else if (this.mustache) {
                unarchiver.unarchive(archive, this.outputDirectory, (UnarchivingEntryProcessor)new MustacheFilteringProcessor(context.getVariables()));
            } else {
                unarchiver.unarchive(archive, this.outputDirectory);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] split(String s) {
        if (s == null) {
            return new String[0];
        }
        return StringUtils.split((String)s, (String)",");
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public boolean isUseRoot() {
        return this.useRoot;
    }

    public void setUseRoot(boolean useRoot) {
        this.useRoot = useRoot;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public boolean isDereferenceHardlinks() {
        return this.dereferenceHardlinks;
    }

    public void setDereferenceHardlinks(boolean dereferenceHardlinks) {
        this.dereferenceHardlinks = dereferenceHardlinks;
    }

    public ProvisioArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ProvisioArtifact artifact) {
        this.artifact = artifact;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isMustache() {
        return this.mustache;
    }

    public void setMustache(boolean mustache) {
        this.mustache = mustache;
    }
}

