/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.action.artifact;

import ca.vanzyl.provisio.ProvisioningException;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.ProvisioningContext;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import javax.inject.Named;

@Named(value="write")
public class WriteToDiskAction
implements ProvisioningAction {
    private ProvisioArtifact artifact;
    private File outputDirectory;

    public WriteToDiskAction(ProvisioArtifact artifact, File outputDirectory) {
        Preconditions.checkArgument((outputDirectory != null ? 1 : 0) != 0, (Object)"outputDirectory cannot be null.");
        this.artifact = artifact;
        this.outputDirectory = outputDirectory;
    }

    public void execute(ProvisioningContext context) {
        File file = this.artifact.getFile();
        if (file != null) {
            String targetName = this.artifact.getName() != null ? this.artifact.getName() : file.getName();
            this.copy(file, new File(this.outputDirectory, targetName));
        }
    }

    public void copy(File source, File target) {
        try {
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            Files.copy((File)source, (File)target);
        }
        catch (IOException e) {
            throw new ProvisioningException("Error copying " + source + " to " + target, e);
        }
    }
}

