/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.action.artifact.alter;

import ca.vanzyl.provisio.MavenProvisioner;
import ca.vanzyl.provisio.ProvisioUtils;
import ca.vanzyl.provisio.action.artifact.alter.Delete;
import ca.vanzyl.provisio.action.artifact.alter.Insert;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.ProvisioningContext;
import ca.vanzyl.provisio.perms.PosixModes;
import io.tesla.proviso.archive.Archiver;
import io.tesla.proviso.archive.UnArchiver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="insert")
public class AlterAction
implements ProvisioningAction {
    private static Logger logger = LoggerFactory.getLogger(AlterAction.class);
    private List<Insert> inserts;
    private List<Delete> deletes;
    private ProvisioArtifact artifact;
    private File outputDirectory;
    private MavenProvisioner provisioner;

    public void execute(ProvisioningContext context) {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File archive = this.artifact.getFile();
        try {
            UnArchiver unarchiver = UnArchiver.builder().build();
            File unpackDirectory = new File(this.outputDirectory, "unpack");
            unarchiver.unarchive(archive, unpackDirectory);
            if (this.inserts != null) {
                for (Insert insert : this.inserts) {
                    for (ProvisioArtifact insertArtifact : insert.getArtifacts()) {
                        this.provisioner.resolveArtifact(context, insertArtifact);
                        File source = insertArtifact.getFile();
                        File target = new File(unpackDirectory, insertArtifact.getName());
                        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            }
            if (this.deletes != null) {
                for (Delete delete : this.deletes) {
                    for (ca.vanzyl.provisio.model.File fileModel : delete.getFiles()) {
                        logger.info("Deleting file {} from {}", (Object)fileModel.getPath(), (Object)this.artifact);
                        File target = new File(unpackDirectory, fileModel.getPath());
                        if (!target.exists()) {
                            throw new RuntimeException("The file specified to delete does not exist: " + fileModel.getPath());
                        }
                        FileUtils.forceDelete((File)target);
                    }
                }
            }
            this.setFilesReadable(unpackDirectory);
            Archiver archiver = Archiver.builder().useRoot(false).build();
            String artifactName = this.artifact.getName() != null ? this.artifact.getName() : ProvisioUtils.coordinateToPath(this.artifact);
            File alteredArtifact = new File(this.outputDirectory, artifactName);
            archiver.archive(alteredArtifact, new File[]{unpackDirectory});
            FileUtils.deleteDirectory((File)unpackDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setFilesReadable(File directory) throws IOException {
        Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                AlterAction.this.setPermissionsOn(path, 493);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException exc) throws IOException {
                AlterAction.this.setPermissionsOn(path, 493);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void setPermissionsOn(Path p, int intMode) throws IOException {
        if (File.pathSeparatorChar == ';') {
            return;
        }
        Files.setPosixFilePermissions(p, PosixModes.intModeToPosix(intMode));
    }

    public List<Insert> getInserts() {
        return this.inserts;
    }

    public void setInserts(List<Insert> inserts) {
        this.inserts = inserts;
    }

    public List<Delete> getDeletes() {
        return this.deletes;
    }

    public void setDeletes(List<Delete> deletes) {
        this.deletes = deletes;
    }

    public ProvisioArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ProvisioArtifact artifact) {
        this.artifact = artifact;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public MavenProvisioner getProvisioner() {
        return this.provisioner;
    }

    public void setProvisioner(MavenProvisioner provisioner) {
        this.provisioner = provisioner;
    }
}

