/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio;

import ca.vanzyl.provisio.Lookup;
import ca.vanzyl.provisio.ProvisioningException;
import ca.vanzyl.provisio.action.artifact.WriteToDiskAction;
import ca.vanzyl.provisio.model.ArtifactSet;
import ca.vanzyl.provisio.model.Directory;
import ca.vanzyl.provisio.model.Exclusion;
import ca.vanzyl.provisio.model.File;
import ca.vanzyl.provisio.model.FileSet;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.ProvisioningContext;
import ca.vanzyl.provisio.model.ProvisioningRequest;
import ca.vanzyl.provisio.model.ProvisioningResult;
import ca.vanzyl.provisio.model.Resource;
import ca.vanzyl.provisio.model.ResourceSet;
import ca.vanzyl.provisio.model.Runtime;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.DependencyGraphDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProvisioner {
    private static final Logger logger = LoggerFactory.getLogger(MavenProvisioner.class);
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;
    Lookup lookup = new Lookup();

    public MavenProvisioner(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
    }

    public ProvisioningResult provision(ProvisioningRequest request) throws Exception {
        ProvisioningResult result = new ProvisioningResult(request);
        ProvisioningContext context = new ProvisioningContext(request, result);
        this.processArtifactSets(context);
        this.processResourceSets(context);
        this.processFileSets(context);
        this.processRuntimeActions(context);
        return result;
    }

    public Set<ProvisioArtifact> resolveArtifacts(ProvisioningRequest request) {
        ProvisioningContext context = new ProvisioningContext(request, null);
        HashSet<ProvisioArtifact> result = new HashSet<ProvisioArtifact>();
        for (ArtifactSet artifactSet : context.getRequest().getRuntimeModel().getArtifactSets()) {
            result.addAll(this.resolveArtifactSet(context, artifactSet));
        }
        return result;
    }

    public List<ProvisioArtifact> getArtifacts(ProvisioningRequest request) {
        ProvisioningContext context = new ProvisioningContext(request, null);
        ArrayList<ProvisioArtifact> result = new ArrayList<ProvisioArtifact>();
        for (ArtifactSet artifactSet : context.getRequest().getRuntimeModel().getArtifactSets()) {
            result.addAll(this.getArtifactsFromSet(context, artifactSet));
        }
        return result;
    }

    private void processArtifactSets(ProvisioningContext context) throws Exception {
        for (ArtifactSet artifactSet : context.getRequest().getRuntimeModel().getArtifactSets()) {
            this.processArtifactSet(context, artifactSet);
        }
    }

    private void processArtifactSet(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
        this.resolveArtifactSetOutputDirectory(context, artifactSet);
        this.resolveArtifactSet(context, artifactSet);
        this.processArtifactsWithActions(context, artifactSet);
        this.processArtifactSetActions(context, artifactSet);
        if (artifactSet.getArtifactSets() != null) {
            for (ArtifactSet childArtifactSet : artifactSet.getArtifactSets()) {
                this.processArtifactSet(context, childArtifactSet);
            }
        }
    }

    private void resolveArtifactSetOutputDirectory(ProvisioningContext context, ArtifactSet artifactSet) {
        ArtifactSet parent = artifactSet.getParent();
        if (parent != null) {
            artifactSet.setOutputDirectory(new java.io.File(parent.getOutputDirectory(), artifactSet.getDirectory()));
        } else if (artifactSet.getDirectory().equals("root") || artifactSet.getDirectory().equals("/")) {
            artifactSet.setOutputDirectory(context.getRequest().getOutputDirectory());
        } else {
            artifactSet.setOutputDirectory(new java.io.File(context.getRequest().getOutputDirectory(), artifactSet.getDirectory()));
        }
        if (!artifactSet.getOutputDirectory().exists()) {
            artifactSet.getOutputDirectory().mkdirs();
        }
    }

    private void processArtifactSetActions(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
    }

    private void processArtifactsWithActions(ProvisioningContext context, ArtifactSet artifactSet) throws Exception {
        for (ProvisioArtifact artifact : artifactSet.getResolvedArtifacts()) {
            WriteToDiskAction action2;
            if (artifact.getActions() != null) {
                for (WriteToDiskAction action2 : artifact.getActions()) {
                    this.configureArtifactAction(artifact, action2, artifactSet.getOutputDirectory());
                    action2.execute(context);
                }
                continue;
            }
            action2 = new WriteToDiskAction(artifact, artifactSet.getOutputDirectory());
            action2.execute(context);
        }
    }

    private Set<ProvisioArtifact> resolveArtifactSet(ProvisioningContext context, ArtifactSet artifactSet) {
        List artifacts;
        if (artifactSet.getReference() != null) {
            Runtime runtime = context.getRequest().getRuntimeModel();
            if (runtime.getArtifactSetReferences() == null) {
                throw new RuntimeException(String.format("The reference '%s' is being requested but the artifactSet references are null.", artifactSet.getReference()));
            }
            ArtifactSet referenceArtifactSet = (ArtifactSet)runtime.getArtifactSetReferences().get(artifactSet.getReference());
            if (referenceArtifactSet == null) {
                throw new RuntimeException(String.format("The is no '%s' artifactSet reference available.", artifactSet.getReference()));
            }
            artifacts = referenceArtifactSet.getArtifacts();
        } else {
            artifacts = artifactSet.getArtifacts();
        }
        HashSet<ProvisioArtifact> parentResolved = artifactSet.getParent() != null ? artifactSet.getParent().getResolvedArtifacts() : new HashSet();
        Set<ProvisioArtifact> resolvedArtifacts = this.resolveArtifacts(context, artifacts, parentResolved, artifactSet.getExcludes());
        artifactSet.setResolvedArtifacts(resolvedArtifacts);
        ArtifactSet parent = artifactSet.getParent();
        if (parent != null) {
            Set parentArtifacts = artifactSet.getParent().getResolvedArtifacts();
            Set childResolvedArtifacts = resolvedArtifacts.stream().filter(a -> !parentArtifacts.contains(a)).collect(Collectors.toSet());
            artifactSet.setResolvedArtifacts(childResolvedArtifacts);
        } else {
            artifactSet.setResolvedArtifacts(resolvedArtifacts);
        }
        return resolvedArtifacts;
    }

    private List<ProvisioArtifact> getArtifactsFromSet(ProvisioningContext context, ArtifactSet artifactSet) {
        List artifacts;
        if (artifactSet.getReference() != null) {
            Runtime runtime = context.getRequest().getRuntimeModel();
            if (runtime.getArtifactSetReferences() == null) {
                throw new RuntimeException(String.format("The reference '%s' is being requested but the artifactSet references are null.", artifactSet.getReference()));
            }
            ArtifactSet referenceArtifactSet = (ArtifactSet)runtime.getArtifactSetReferences().get(artifactSet.getReference());
            if (referenceArtifactSet == null) {
                throw new RuntimeException(String.format("The is no '%s' artifactSet reference available.", artifactSet.getReference()));
            }
            artifacts = referenceArtifactSet.getArtifacts();
        } else {
            artifacts = artifactSet.getArtifacts();
        }
        if (artifactSet.getArtifactSets() != null) {
            for (ArtifactSet childSet : artifactSet.getArtifactSets()) {
                artifacts.addAll(this.getArtifactsFromSet(context, childSet));
            }
        }
        return artifacts;
    }

    public Set<ProvisioArtifact> resolveArtifact(ProvisioningContext context, ProvisioArtifact artifact) {
        return this.resolveArtifacts(context, Collections.singletonList(artifact), new HashSet<ProvisioArtifact>(), new ArrayList<Exclusion>());
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProvisioArtifact> resolveArtifacts(ProvisioningContext context, List<ProvisioArtifact> artifacts, Set<ProvisioArtifact> managedArtifacts, List<Exclusion> excludes) {
        List<Artifact> list;
        CollectRequest request = new CollectRequest();
        if (artifacts == null) {
            artifacts = new ArrayList<ProvisioArtifact>();
        }
        if (managedArtifacts == null) {
            managedArtifacts = new HashSet<ProvisioArtifact>();
        }
        ArrayList<ProvisioArtifact> providedArtifacts = new ArrayList<ProvisioArtifact>();
        for (ProvisioArtifact artifact : artifacts) {
            void var9_18;
            if (artifact.getReference() != null) {
                Runtime runtime = context.getRequest().getRuntimeModel();
                if (runtime.getArtifactReferences() == null) {
                    throw new RuntimeException(String.format("The reference '%s' is being requested but the artifact references are null.", artifact.getReference()));
                }
                ProvisioArtifact referenceArtifact = (ProvisioArtifact)runtime.getArtifactReferences().get(artifact.getReference());
                if (referenceArtifact == null) {
                    throw new RuntimeException(String.format("The is no '%s' artifact reference available.", artifact.getReference()));
                }
                if (artifact.getName() != null) {
                    referenceArtifact.setName(artifact.getName());
                }
                providedArtifacts.add(referenceArtifact);
                continue;
            }
            if (artifact.getFile() != null) {
                providedArtifacts.add(artifact);
                continue;
            }
            Object var9_11 = null;
            if (artifact.getExtension().equals("tar.gz")) {
                DefaultArtifactType defaultArtifactType = new DefaultArtifactType("tar.gz", "tar.gz", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("zip")) {
                DefaultArtifactType defaultArtifactType = new DefaultArtifactType("zip", "zip", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("war")) {
                DefaultArtifactType defaultArtifactType = new DefaultArtifactType("war", "war", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("hpi")) {
                DefaultArtifactType defaultArtifactType = new DefaultArtifactType("hpi", "hpi", "", "packaging", false, true);
            } else if (artifact.getExtension().equals("jpi")) {
                DefaultArtifactType defaultArtifactType = new DefaultArtifactType("jpi", "jpi", "", "packaging", false, true);
            } else if (this.getArtifactType(artifact.getExtension()) == null) {
                DefaultArtifactType defaultArtifactType = new DefaultArtifactType(artifact.getExtension(), artifact.getExtension(), "", "unknown", false, true);
            }
            if (var9_18 != null) {
                artifact = artifact.setProperties(var9_18.getProperties());
            }
            Dependency dependency = new Dependency((Artifact)artifact, "runtime");
            if (artifact.getExclusions() != null) {
                HashSet exclusions = new HashSet();
                for (String exclusion : artifact.getExclusions()) {
                    String[] ga = StringUtils.split((String)exclusion, (String)":");
                    if (ga.length == 2) {
                        exclusions.add(new org.eclipse.aether.graph.Exclusion(ga[0], ga[1], "*", "*"));
                        continue;
                    }
                    if (ga.length != 1) continue;
                    exclusions.add(new org.eclipse.aether.graph.Exclusion(null, ga[0], "*", "*"));
                }
                dependency = dependency.setExclusions((Collection)exclusions);
            }
            request.addDependency(dependency);
        }
        ScopeDependencyFilter systemScopeFilter = new ScopeDependencyFilter(new String[]{"system", "provided", "test"});
        DependencyRequest dependencyRequest = new DependencyRequest(request, null);
        if (excludes != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Exclusion exclusion : excludes) {
                arrayList.add(exclusion.getId());
            }
            ExclusionsDependencyFilter exclusionsFilter = new ExclusionsDependencyFilter(arrayList);
            dependencyRequest.setFilter((DependencyFilter)new AndDependencyFilter(new DependencyFilter[]{exclusionsFilter, systemScopeFilter}));
        } else {
            dependencyRequest.setFilter((DependencyFilter)systemScopeFilter);
        }
        for (String string : context.getRequest().getManagedDependencies()) {
            ProvisioArtifact artifact = new ProvisioArtifact(string);
            request.addManagedDependency(new Dependency((Artifact)artifact, "runtime"));
        }
        for (Artifact artifact : managedArtifacts) {
            request.addManagedDependency(new Dependency(artifact, "runtime"));
        }
        try {
            list = this.resolveArtifacts(dependencyRequest);
            list.addAll(providedArtifacts);
        }
        catch (DependencyResolutionException e) {
            throw new ProvisioningException(e.getMessage(), e);
        }
        HashMap<String, ProvisioArtifact> artifactMapKeyedByGa = new HashMap<String, ProvisioArtifact>(artifacts.stream().collect(Collectors.toMap(this::artifactKey, a -> a)));
        HashSet<ProvisioArtifact> resolvedArtifacts = new HashSet<ProvisioArtifact>();
        for (Artifact a2 : list) {
            ProvisioArtifact resolvedArtifact;
            String key = this.artifactKey(a2);
            if (a2 instanceof ProvisioArtifact) {
                artifactMapKeyedByGa.put(key, (ProvisioArtifact)a2);
                resolvedArtifacts.add((ProvisioArtifact)a2);
                continue;
            }
            ProvisioArtifact provisioArtifact = (ProvisioArtifact)artifactMapKeyedByGa.get(key);
            if (provisioArtifact == null) {
                resolvedArtifact = new ProvisioArtifact(a2);
                artifactMapKeyedByGa.put(key, resolvedArtifact);
                resolvedArtifacts.add(resolvedArtifact);
                continue;
            }
            resolvedArtifact = provisioArtifact.setFile(a2.getFile());
            artifactMapKeyedByGa.put(key, resolvedArtifact);
            resolvedArtifacts.add(resolvedArtifact);
        }
        return resolvedArtifacts;
    }

    private String artifactKey(Artifact artifact) {
        return String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + ":" + artifact.getClassifier();
    }

    private List<Artifact> resolveArtifacts(DependencyRequest request) throws DependencyResolutionException {
        CollectRequest collectRequest = request.getCollectRequest();
        if (collectRequest.getRepositories() == null || collectRequest.getRepositories().isEmpty()) {
            for (RemoteRepository remoteRepository : this.remoteRepositories) {
                collectRequest.addRepository(remoteRepository);
            }
        }
        DependencyResult result = this.repositorySystem.resolveDependencies(this.repositorySystemSession, request);
        if (logger.isDebugEnabled() && result.getRoot() != null) {
            logger.debug("MavenProvisioner -- Collection result for {}", (Object)request.getCollectRequest());
            result.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(arg_0 -> ((Logger)logger).debug(arg_0)));
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (ArtifactResult ar : result.getArtifactResults()) {
            artifacts.add(ar.getArtifact());
        }
        return artifacts;
    }

    private ArtifactType getArtifactType(String typeId) {
        return this.repositorySystemSession.getArtifactTypeRegistry().get(typeId);
    }

    private void processResourceSets(ProvisioningContext context) throws Exception {
        List resourceSets = context.getRequest().getRuntime().getResourceSets();
        if (resourceSets != null) {
            for (ResourceSet resourceSet : resourceSets) {
                for (Resource resource : resourceSet.getResources()) {
                    java.io.File source = new java.io.File(resource.getName());
                    if (!source.exists()) {
                        throw new RuntimeException(String.format("The specified file %s does not exist.", source));
                    }
                    java.io.File target = new java.io.File(context.getRequest().getOutputDirectory(), source.getName());
                    this.copy(source, target);
                }
            }
        }
    }

    private void processFileSets(ProvisioningContext context) throws Exception {
        List fileSets = context.getRequest().getRuntime().getFileSets();
        if (fileSets != null) {
            for (FileSet fileSet : fileSets) {
                for (File file : fileSet.getFiles()) {
                    if (file.getTouch() != null) {
                        java.io.File target = new java.io.File(new java.io.File(context.getRequest().getOutputDirectory(), fileSet.getDirectory()), file.getTouch());
                        if (!target.getParentFile().exists()) {
                            target.getParentFile().mkdirs();
                        }
                        Files.createFile(target.toPath(), new FileAttribute[0]);
                        continue;
                    }
                    java.io.File source = new java.io.File(file.getPath());
                    if (!source.exists()) {
                        throw new RuntimeException(String.format("The specified file %s does not exist.", source));
                    }
                    java.io.File target = new java.io.File(new java.io.File(context.getRequest().getOutputDirectory(), fileSet.getDirectory()), source.getName());
                    this.copy(source, target);
                }
                for (Directory directory : fileSet.getDirectories()) {
                    java.io.File sourceDirectory = new java.io.File(directory.getPath());
                    java.io.File targetDirectory = new java.io.File(context.getRequest().getOutputDirectory(), fileSet.getDirectory());
                    this.copyDirectoryStructure(sourceDirectory, targetDirectory, directory);
                }
            }
        }
    }

    private void copyDirectoryStructure(java.io.File sourceDirectory, java.io.File targetDirectory, Directory directory) throws IOException {
        List includes = directory.getIncludes();
        List excludes = directory.getExcludes();
        String includesString = null;
        if (includes != null && !includes.isEmpty()) {
            includesString = String.join((CharSequence)",", includes);
        }
        String excludesString = null;
        if (excludes != null && !excludes.isEmpty()) {
            excludesString = String.join((CharSequence)",", excludes);
        }
        if (directory.isFlatten()) {
            List paths = FileUtils.getFiles((java.io.File)sourceDirectory, (String)includesString, (String)excludesString);
            for (java.io.File source : paths) {
                java.io.File target = new java.io.File(targetDirectory, source.getName());
                this.copy(source, target);
            }
        } else {
            List relativePaths = FileUtils.getFileNames((java.io.File)sourceDirectory, (String)includesString, (String)excludesString, (boolean)false);
            for (String relativePath : relativePaths) {
                java.io.File source = new java.io.File(sourceDirectory, relativePath);
                java.io.File target = new java.io.File(targetDirectory, relativePath);
                this.copy(source, target);
            }
        }
    }

    private void copy(java.io.File source, java.io.File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    private void processRuntimeActions(ProvisioningContext context) throws Exception {
        List runtimeActions = context.getRequest().getRuntime().getActions();
        if (runtimeActions != null) {
            for (ProvisioningAction action : runtimeActions) {
                this.configureArtifactSetAction(action, context.getRequest().getOutputDirectory());
                action.execute(context);
            }
        }
    }

    private void configureArtifactSetAction(ProvisioningAction provisioningAction, java.io.File outputDirectory) {
        this.lookup.setObjectProperty(provisioningAction, "fileSetDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "outputDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "runtimeDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "provisioner", this);
    }

    private void configureArtifactAction(ProvisioArtifact artifact, ProvisioningAction provisioningAction, java.io.File outputDirectory) {
        this.lookup.setObjectProperty(provisioningAction, "artifact", artifact);
        this.lookup.setObjectProperty(provisioningAction, "fileSetDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "outputDirectory", outputDirectory);
        this.lookup.setObjectProperty(provisioningAction, "provisioner", this);
    }
}

