/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio;

import ca.vanzyl.provisio.model.ProvisioArtifact;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ProvisioUtils {
    private static final int MAXIMUM_FILENAME_LENGTH = 64;
    private static final String GROUP_ARTIFACT_SEPARATOR = "_";
    private static final String ELLIPSIS = "...";

    public static String coordinateToPath(ProvisioArtifact a) {
        StringBuffer path = new StringBuffer().append(a.getArtifactId()).append("-").append(a.getVersion());
        if (a.getClassifier() != null && !a.getClassifier().isEmpty()) {
            path.append("-").append(a.getClassifier());
        }
        path.append(".").append(a.getExtension());
        return path.toString();
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        byte[] buf = new byte[4096];
        long total = 0L;
        int r;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static String targetArtifactFileName(ProvisioArtifact artifact, String name) {
        if (artifact.getName() == null && name == null) {
            throw new IllegalArgumentException("Artifact name and file name are both null");
        }
        String filenameSuffix = artifact.getName() != null ? artifact.getName() : name;
        int remaining = 64 - filenameSuffix.length() - GROUP_ARTIFACT_SEPARATOR.length();
        if (remaining <= 0) {
            return StringUtils.abbreviateMiddle((String)filenameSuffix, (String)ELLIPSIS, (int)64);
        }
        return String.valueOf(StringUtils.abbreviateMiddle((String)artifact.getGroupId(), (String)ELLIPSIS, (int)remaining)) + GROUP_ARTIFACT_SEPARATOR + filenameSuffix;
    }
}

