/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.action.artifact;

import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.ProvisioningContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="exclude")
public class ExcludeAction
implements ProvisioningAction {
    private static final Logger logger = LoggerFactory.getLogger(ExcludeAction.class);
    private String dir;
    private String file;
    private File outputDirectory;

    public void execute(ProvisioningContext context) {
        try {
            if (this.dir != null) {
                logger.info("Excluding directory {} in {}", (Object)this.dir, (Object)this.outputDirectory);
                Path dirToDelete = this.outputDirectory.toPath().resolve(this.dir);
                if (!Files.exists(dirToDelete, new LinkOption[0])) {
                    throw new RuntimeException("The excluded dir you specified doesn't exist:" + dirToDelete);
                }
                this.deletePath(this.outputDirectory.toPath().resolve(this.dir));
            }
            if (this.file != null) {
                logger.info("Excluding file {} in {}", (Object)this.file, (Object)this.outputDirectory);
                Path fileToDelete = this.outputDirectory.toPath().resolve(this.file);
                if (!Files.exists(fileToDelete, new LinkOption[0])) {
                    throw new RuntimeException("The excluded file you specified doesn't exist:" + fileToDelete);
                }
                Files.delete(this.outputDirectory.toPath().resolve(this.file));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void deletePath(Path pathToBeDeleted) throws IOException {
        Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }
}

