/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.action.runtime;

import ca.vanzyl.provisio.archive.Archiver;
import ca.vanzyl.provisio.archive.UnArchiver;
import ca.vanzyl.provisio.model.ProvisioArchive;
import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.ProvisioningContext;
import java.io.File;
import org.codehaus.plexus.util.StringUtils;

public class ArchiveAction
implements ProvisioningAction {
    private String name;
    private String executable;
    private File runtimeDirectory;
    private String hardLinkIncludes;
    private String hardLinkExcludes;
    private boolean useRoot = true;

    public void execute(ProvisioningContext context) {
        Archiver.ArchiverBuilder builder = Archiver.builder();
        if (this.executable != null) {
            builder.executable(StringUtils.split((String)this.executable, (String)","));
        }
        Archiver archiver = builder.posixLongFileMode(true).useRoot(this.useRoot).normalize(true).hardLinkIncludes(this.split(this.hardLinkIncludes)).hardLinkExcludes(this.split(this.hardLinkExcludes)).build();
        try {
            File archive = new File(this.runtimeDirectory, "../" + this.name).getCanonicalFile();
            archiver.archive(archive, new File[]{this.runtimeDirectory});
            String extension = archive.getName().endsWith("tar.gz") ? "tar.gz" : "zip";
            ProvisioArchive provisioArchive = new ProvisioArchive(archive, extension);
            context.getResult().addArchive(provisioArchive);
            if (this.hardLinkIncludes != null) {
                UnArchiver unArchiver = UnArchiver.builder().useRoot(false).build();
                unArchiver.unarchive(archive, new File(this.runtimeDirectory + "-hardlinks"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File getRuntimeDirectory() {
        return this.runtimeDirectory;
    }

    public void setRuntimeDirectory(File runtimeDirectory) {
        this.runtimeDirectory = runtimeDirectory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String[] split(String s) {
        if (s == null) {
            return new String[0];
        }
        return StringUtils.split((String)s, (String)",");
    }

    public boolean isUseRoot() {
        return this.useRoot;
    }

    public void setUseRoot(boolean useRoot) {
        this.useRoot = useRoot;
    }
}

