/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio;

import ca.vanzyl.provisio.ProvisioVariables;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningContext;

public class ProvisioUtils {
    private static final String ELLIPSIS = "...";

    public static String coordinateToPath(ProvisioArtifact a) {
        StringBuilder path = new StringBuilder().append(a.getArtifactId()).append("-").append(a.getVersion());
        if (a.getClassifier() != null && !a.getClassifier().isEmpty()) {
            path.append("-").append(a.getClassifier());
        }
        path.append(".").append(a.getExtension());
        return path.toString();
    }

    public static String targetArtifactFileName(ProvisioningContext context, ProvisioArtifact artifact, String artifactResolvedFilename) {
        if (artifact.getName() == null && artifactResolvedFilename == null) {
            throw new IllegalArgumentException("Artifact name and file name are both null");
        }
        if (artifact.getName() != null) {
            return artifact.getName();
        }
        ProvisioVariables.FallBackTargetFileNameMode mode = ProvisioVariables.fallbackTargetFileNameMode(context);
        switch (mode) {
            case ARTIFACT_FILE_NAME: {
                return artifactResolvedFilename;
            }
            case GA: {
                int maxFileNameLength = ProvisioVariables.gaMaxFileNameLength(context);
                String gaSeparator = ProvisioVariables.gaSeparator(context);
                int remaining = maxFileNameLength - artifactResolvedFilename.length() - gaSeparator.length();
                if (remaining <= 0) {
                    return ProvisioUtils.abbreviateMiddle(artifactResolvedFilename, ELLIPSIS, maxFileNameLength);
                }
                return String.valueOf(ProvisioUtils.abbreviateMiddle(artifact.getGroupId(), ELLIPSIS, remaining)) + gaSeparator + artifactResolvedFilename;
            }
        }
        throw new IllegalStateException("Unknown mode for fallback target file name: " + (Object)((Object)mode));
    }

    private static String abbreviateMiddle(String str, String middle, int length) {
        if (str != null && !str.trim().isEmpty() && middle != null && !middle.trim().isEmpty() && length < str.length() && length >= middle.length() + 2) {
            int targetSting = length - middle.length();
            int startOffset = targetSting / 2 + targetSting % 2;
            int endOffset = str.length() - targetSting / 2;
            return String.valueOf(str.substring(0, startOffset)) + middle + str.substring(endOffset);
        }
        return str;
    }
}

