/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.action.artifact.filter;

import ca.vanzyl.provisio.ProvisioVariables;
import ca.vanzyl.provisio.ProvisioningException;
import ca.vanzyl.provisio.archive.UnarchivingEnhancedEntryProcessor;
import ca.vanzyl.provisio.model.ProvisioningContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatProcessor
implements UnarchivingEnhancedEntryProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StatProcessor.class);
    private final ProvisioningContext context;
    private final Path archive;
    private final Path outputDirectory;
    private final UnarchivingEnhancedEntryProcessor delegate;

    public StatProcessor(ProvisioningContext context, Path archive, Path outputDirectory, UnarchivingEnhancedEntryProcessor delegate) {
        this.context = Objects.requireNonNull(context);
        this.archive = Objects.requireNonNull(archive);
        this.outputDirectory = Objects.requireNonNull(outputDirectory);
        this.delegate = delegate;
    }

    public String targetName(String name) {
        String result = name;
        if (this.delegate != null) {
            result = this.delegate.targetName(name);
        }
        return result;
    }

    public String sourceName(String name) {
        String result = name;
        if (this.delegate != null) {
            result = this.delegate.sourceName(name);
        }
        return result;
    }

    public void processStream(String entryName, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (this.delegate != null) {
            this.delegate.processStream(entryName, inputStream, outputStream);
        } else {
            inputStream.transferTo(outputStream);
        }
    }

    public void processed(String entryName, Path target) {
        if (!target.startsWith(this.outputDirectory)) {
            throw new IllegalArgumentException("Bad mapping of archive " + this.archive + " entry " + entryName + "; would escape output directory: " + this.outputDirectory);
        }
        if (!Files.isDirectory(target, new LinkOption[0]) && !this.context.layDownFile(target)) {
            if (ProvisioVariables.allowTargetOverwrite(this.context)) {
                logger.warn("Conflict: archive {} entry {} overwrites existing file {}", new Object[]{this.archive, entryName, target});
            } else {
                throw new ProvisioningException("Conflict: archive " + this.archive + " entry " + entryName + " would overwrite existing file: " + target);
            }
        }
    }
}

