/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.model;

import ca.vanzyl.provisio.model.ProvisioningAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ProvisioArtifact
extends AbstractArtifact {
    private String name;
    private List<ProvisioningAction> actions;
    private Artifact delegate;
    private String coordinate;
    private List<String> exclusions;
    private String reference;

    public ProvisioArtifact(String coordinate) {
        this(coordinate, null);
    }

    public ProvisioArtifact(String coordinate, String name) {
        if (coordinate.indexOf(":") > 0) {
            this.delegate = new DefaultArtifact(coordinate);
            this.coordinate = coordinate;
        } else {
            this.reference = coordinate;
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public ProvisioArtifact(Artifact a) {
        this.delegate = a;
    }

    public String getCoordinate() {
        return this.coordinate;
    }

    public String getGA() {
        return String.valueOf(this.getGroupId()) + ":" + this.getArtifactId();
    }

    public String getGAV() {
        return String.valueOf(this.getGroupId()) + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public String toVersionlessCoordinate() {
        StringBuffer sb = new StringBuffer().append(this.getGroupId()).append(":").append(this.getArtifactId()).append(":").append(this.getExtension());
        if (this.getClassifier() != null && !this.getClassifier().isEmpty()) {
            sb.append(":").append(this.getClassifier());
        }
        return sb.toString();
    }

    public List<ProvisioningAction> getActions() {
        return this.actions;
    }

    public void addAction(ProvisioningAction action) {
        if (this.actions == null) {
            this.actions = new ArrayList<ProvisioningAction>();
        }
        this.actions.add(action);
    }

    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public Artifact setVersion(String version) {
        this.delegate = this.delegate.setVersion(version);
        return this;
    }

    public String getBaseVersion() {
        return this.delegate.getBaseVersion();
    }

    public boolean isSnapshot() {
        return this.delegate.isSnapshot();
    }

    public String getClassifier() {
        return this.delegate.getClassifier();
    }

    public String getExtension() {
        return this.delegate.getExtension();
    }

    public File getFile() {
        return this.delegate.getFile();
    }

    public Artifact setFile(File file) {
        this.delegate = this.delegate.setFile(file);
        return this;
    }

    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    public Artifact setProperties(Map<String, String> properties) {
        this.delegate = this.delegate.setProperties(properties);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProvisioArtifact) {
            return this.delegate.equals(((ProvisioArtifact)((Object)obj)).delegate);
        }
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addExclusion(String exclude) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<String>();
        }
        this.exclusions.add(exclude);
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }
}

