/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.model.io;

import ca.vanzyl.provisio.model.ActionDescriptor;
import ca.vanzyl.provisio.model.Alias;
import ca.vanzyl.provisio.model.ArtifactSet;
import ca.vanzyl.provisio.model.Directory;
import ca.vanzyl.provisio.model.Exclusion;
import ca.vanzyl.provisio.model.File;
import ca.vanzyl.provisio.model.FileSet;
import ca.vanzyl.provisio.model.Implicit;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningAction;
import ca.vanzyl.provisio.model.Resource;
import ca.vanzyl.provisio.model.ResourceSet;
import ca.vanzyl.provisio.model.Runtime;
import ca.vanzyl.provisio.model.io.InterpolatingInputStream;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuntimeReader {
    private final XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
    private final Map<String, ActionDescriptor> actionMap;
    private final Map<String, String> versionMap;

    public RuntimeReader() {
        this(Collections.emptyList(), Collections.emptyMap());
    }

    public RuntimeReader(List<ActionDescriptor> actions) {
        this(actions, Collections.emptyMap());
    }

    public RuntimeReader(List<ActionDescriptor> actions, Map<String, String> versionMap) {
        this.xstream.addPermission(NoTypePermission.NONE);
        this.xstream.addPermission(NullPermission.NULL);
        this.xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        this.xstream.allowTypesByWildcard(new String[]{"ca.vanzyl.provisio.model.**", "ca.vanzyl.provisio.action.**"});
        this.xstream.alias("assembly", Runtime.class);
        this.xstream.alias("runtime", Runtime.class);
        this.xstream.useAttributeFor(Runtime.class, "id");
        this.xstream.addImplicitCollection(Runtime.class, "artifactSets");
        this.xstream.addImplicitCollection(Runtime.class, "resourceSets");
        this.xstream.addImplicitCollection(Runtime.class, "fileSets");
        this.xstream.alias("artifactSet", ArtifactSet.class);
        this.xstream.aliasAttribute(ArtifactSet.class, "directory", "to");
        this.xstream.aliasAttribute(ArtifactSet.class, "reference", "ref");
        this.xstream.useAttributeFor(ArtifactSet.class, "providedBom");
        this.xstream.addImplicitCollection(ArtifactSet.class, "artifacts", ProvisioArtifact.class);
        this.xstream.alias("exclude", Exclusion.class);
        this.xstream.useAttributeFor(Exclusion.class, "id");
        this.xstream.addImplicitCollection(ArtifactSet.class, "exclusions", "exclusion", Exclusion.class);
        this.xstream.alias("artifact", ProvisioArtifact.class);
        this.xstream.addImplicitCollection(ArtifactSet.class, "artifactSets", ArtifactSet.class);
        this.xstream.alias("resourceSet", ResourceSet.class);
        this.xstream.addImplicitCollection(ResourceSet.class, "resources");
        this.xstream.alias("resource", Resource.class);
        this.xstream.useAttributeFor(Resource.class, "name");
        this.xstream.alias("fileSet", FileSet.class);
        this.xstream.useAttributeFor(FileSet.class, "to");
        this.xstream.addImplicitCollection(FileSet.class, "files", "file", File.class);
        this.xstream.addImplicitCollection(FileSet.class, "directories", "directory", Directory.class);
        this.xstream.alias("file", File.class);
        this.xstream.useAttributeFor(File.class, "path");
        this.xstream.useAttributeFor(File.class, "touch");
        this.xstream.alias("directory", Directory.class);
        this.xstream.useAttributeFor(Directory.class, "path");
        this.xstream.addImplicitCollection(Directory.class, "includes", "include", String.class);
        this.xstream.addImplicitCollection(Directory.class, "excludes", "exclude", String.class);
        this.xstream.useAttributeFor(Directory.class, "flatten");
        this.xstream.registerConverter((Converter)new RuntimeConverter());
        this.xstream.registerConverter((Converter)new ArtifactConverter());
        for (ActionDescriptor action : actions) {
            String[] stringArray = action.attributes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeForProperty = stringArray[n2];
                this.xstream.useAttributeFor(action.getImplementation(), attributeForProperty);
                ++n2;
            }
            for (Alias alias : action.aliases()) {
                this.xstream.alias(alias.getName(), alias.getType());
            }
            for (Implicit implicit : action.implicits()) {
                if (implicit.getItemType() != null) {
                    this.xstream.addImplicitCollection(implicit.getType(), implicit.getName(), implicit.getItemType());
                    continue;
                }
                this.xstream.addImplicitCollection(implicit.getType(), implicit.getName());
            }
        }
        this.versionMap = versionMap;
        this.actionMap = new HashMap<String, ActionDescriptor>();
        for (ActionDescriptor actionDescriptor : actions) {
            this.actionMap.put(actionDescriptor.getName(), actionDescriptor);
        }
    }

    public Runtime read(InputStream inputStream, Map<String, String> variables) {
        Runtime runtime = (Runtime)this.xstream.fromXML((InputStream)((Object)new InterpolatingInputStream(inputStream, variables)));
        runtime.setVariables(variables);
        return runtime;
    }

    public Runtime read(InputStream inputStream) {
        return (Runtime)this.xstream.fromXML(inputStream);
    }

    public class ArtifactConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return ProvisioArtifact.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            ProvisioArtifact artifact;
            String reference = reader.getAttribute("ref");
            String name = reader.getAttribute("as");
            if (reference != null) {
                artifact = new ProvisioArtifact(reference, name);
            } else {
                String lastElement;
                String coordinate = reader.getAttribute("id");
                int coordinateSegments = coordinate.length() - coordinate.replace(":", "").length() + 1;
                if (coordinateSegments == 2) {
                    coordinate = String.valueOf(coordinate) + ":jar";
                }
                if (!Character.isDigit((lastElement = coordinate.substring(coordinate.lastIndexOf(":") + 1)).charAt(0))) {
                    String version = RuntimeReader.this.versionMap.get(coordinate);
                    if (version != null) {
                        coordinate = String.valueOf(coordinate) + ":" + version;
                    } else {
                        throw new RuntimeException(String.format("A version for %s cannot be found. You either need to specify one in your dependencyManagement section, or explicity set one in your assembly descriptor.", coordinate));
                    }
                }
                artifact = new ProvisioArtifact(coordinate, name);
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String nodeName = reader.getNodeName();
                ActionDescriptor actionDescriptor = RuntimeReader.this.actionMap.get(nodeName);
                if (actionDescriptor != null) {
                    artifact.addAction((ProvisioningAction)context.convertAnother((Object)artifact, actionDescriptor.getImplementation()));
                } else if (nodeName.equals("exclusion")) {
                    String exclude = reader.getAttribute("id");
                    artifact.addExclusion(exclude);
                } else {
                    throw new ConversionException("The element '" + nodeName + "' is invalid inside the <artifact/> context.");
                }
                reader.moveUp();
            }
            return artifact;
        }
    }

    public class RuntimeConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return Runtime.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Runtime runtime = new Runtime();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals("artifactSet")) {
                    runtime.addArtifactSet((ArtifactSet)context.convertAnother((Object)runtime, ArtifactSet.class));
                } else if (reader.getNodeName().equals("resourceSet")) {
                    runtime.addResourceSet((ResourceSet)context.convertAnother((Object)runtime, ResourceSet.class));
                } else if (reader.getNodeName().equals("fileSet")) {
                    runtime.addFileSet((FileSet)context.convertAnother((Object)runtime, FileSet.class));
                } else {
                    String actionName = reader.getNodeName();
                    ActionDescriptor actionDescriptor = RuntimeReader.this.actionMap.get(actionName);
                    if (actionDescriptor != null) {
                        runtime.addAction((ProvisioningAction)context.convertAnother((Object)runtime, actionDescriptor.getImplementation()));
                    } else {
                        throw new ConversionException("The element '" + actionName + "' is invalid inside the <runtime/> context.");
                    }
                }
                reader.moveUp();
            }
            return runtime;
        }
    }
}

