/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.model;

import ca.vanzyl.provisio.model.Exclusion;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtifactSet {
    private String directory;
    private String reference;
    private String from;
    private String providedBom;
    private final List<ProvisioArtifact> artifacts = new ArrayList<ProvisioArtifact>();
    private final List<Resource> resources = new ArrayList<Resource>();
    private final List<ArtifactSet> artifactSets = new ArrayList<ArtifactSet>();
    private List<Exclusion> exclusions;
    private ArtifactSet parent;
    private File outputDirectory;
    private final Map<String, ProvisioArtifact> artifactMap = new LinkedHashMap<String, ProvisioArtifact>();
    private Set<ProvisioArtifact> resolvedArtifacts = new HashSet<ProvisioArtifact>();

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getProvidedBom() {
        return this.providedBom;
    }

    public void setProvidedBom(String providedBom) {
        this.providedBom = providedBom;
    }

    public void addArtifact(ProvisioArtifact artifact) {
        this.artifacts.add(artifact);
    }

    public List<ProvisioArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void addArtifactSet(ArtifactSet artifactSet) {
        this.artifactSets.add(artifactSet);
    }

    public List<ArtifactSet> getArtifactSets() {
        return this.artifactSets;
    }

    public List<Exclusion> getExcludes() {
        return this.exclusions;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public ArtifactSet getParent() {
        return this.parent;
    }

    public void setParent(ArtifactSet parent) {
        this.parent = parent;
    }

    public Set<ProvisioArtifact> getResolvedArtifacts() {
        return this.resolvedArtifacts;
    }

    public void setResolvedArtifacts(Set<ProvisioArtifact> resolvedArtifacts) {
        this.resolvedArtifacts = resolvedArtifacts;
    }

    public Map<String, ProvisioArtifact> getArtifactMap() {
        if (this.artifacts != null) {
            for (ProvisioArtifact artifact : this.artifacts) {
                this.artifactMap.put(artifact.getCoordinate(), artifact);
            }
        }
        return this.artifactMap;
    }

    public String toString() {
        return "ArtifactSet [directory=" + this.directory + ", artifacts=" + this.artifacts + ", artifactSets=" + this.artifactSets + ", parent=" + this.parent + ", resolvedArtifacts=" + this.resolvedArtifacts + "]";
    }

    private Object readResolve() {
        if (this.artifactSets != null) {
            for (ArtifactSet child : this.artifactSets) {
                child.setParent(this);
            }
        }
        return this;
    }
}

