/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.model;

import ca.vanzyl.provisio.model.ProvisioningAction;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ProvisioArtifact
extends AbstractArtifact {
    private String name;
    private List<ProvisioningAction> actions;
    private Artifact delegate;
    private String coordinate;
    private List<String> exclusions;
    private String reference;

    public ProvisioArtifact(String coordinate) {
        this(coordinate, null);
    }

    public ProvisioArtifact(String coordinate, String name) {
        if (coordinate.indexOf(":") > 0) {
            this.delegate = new DefaultArtifact(coordinate);
            this.coordinate = coordinate;
        } else {
            this.reference = coordinate;
        }
        this.name = name;
    }

    public ProvisioArtifact(Artifact a) {
        this.delegate = a;
    }

    private ProvisioArtifact(String name, List<ProvisioningAction> actions, Artifact delegate, String coordinate, List<String> exclusions, String reference) {
        this.name = name;
        this.actions = actions;
        this.delegate = delegate;
        this.coordinate = coordinate;
        this.exclusions = exclusions;
        this.reference = reference;
    }

    public String getName() {
        return this.name;
    }

    public String getReference() {
        return this.reference;
    }

    public String getCoordinate() {
        return this.coordinate;
    }

    public String getGA() {
        return String.valueOf(this.getGroupId()) + ":" + this.getArtifactId();
    }

    public String getGAV() {
        return String.valueOf(this.getGroupId()) + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public String toVersionlessCoordinate() {
        StringBuilder sb = new StringBuilder().append(this.getGroupId()).append(":").append(this.getArtifactId()).append(":").append(this.getExtension());
        if (this.getClassifier() != null && !this.getClassifier().isEmpty()) {
            sb.append(":").append(this.getClassifier());
        }
        return sb.toString();
    }

    public List<ProvisioningAction> getActions() {
        return this.actions;
    }

    public void addAction(ProvisioningAction action) {
        if (this.actions == null) {
            this.actions = new ArrayList<ProvisioningAction>();
        }
        this.actions.add(action);
    }

    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public ProvisioArtifact setVersion(String version) {
        Artifact newArtifact = this.delegate.setVersion(version);
        if (this.delegate == newArtifact) {
            return this;
        }
        return new ProvisioArtifact(this.name, this.actions, newArtifact, this.coordinate, this.exclusions, this.reference);
    }

    public String getBaseVersion() {
        return this.delegate.getBaseVersion();
    }

    public boolean isSnapshot() {
        return this.delegate.isSnapshot();
    }

    public String getClassifier() {
        return this.delegate.getClassifier();
    }

    public String getExtension() {
        return this.delegate.getExtension();
    }

    public File getFile() {
        return this.delegate.getFile();
    }

    public ProvisioArtifact setFile(File file) {
        Artifact newArtifact = this.delegate.setFile(file);
        if (this.delegate == newArtifact) {
            return this;
        }
        return new ProvisioArtifact(this.name, this.actions, newArtifact, this.coordinate, this.exclusions, this.reference);
    }

    public Path getPath() {
        File file = this.getFile();
        return file != null ? file.toPath() : null;
    }

    public Artifact setPath(Path path) {
        Path current = this.getPath();
        if (Objects.equals(current, path)) {
            return this;
        }
        return this.setFile(path != null ? path.toFile() : null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    public ProvisioArtifact setProperties(Map<String, String> properties) {
        Artifact newArtifact = this.delegate.setProperties(properties);
        if (this.delegate == newArtifact) {
            return this;
        }
        return new ProvisioArtifact(this.name, this.actions, newArtifact, this.coordinate, this.exclusions, this.reference);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ProvisioArtifact) {
            return this.delegate.equals(((ProvisioArtifact)((Object)obj)).delegate);
        }
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addExclusion(String exclude) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<String>();
        }
        this.exclusions.add(exclude);
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }
}

