/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.maven.plugins.provisio;

import ca.vanzyl.maven.plugins.provisio.Provisio;
import ca.vanzyl.provisio.model.ArtifactSet;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningRequest;
import ca.vanzyl.provisio.model.Runtime;
import io.takari.incrementalbuild.Incremental;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.DependencyGraphDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMojo
extends AbstractMojo {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    protected RepositorySystem repositorySystem;
    @Inject
    protected Provisio provisio;
    @Inject
    protected MavenProjectHelper projectHelper;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(required=true, defaultValue="${basedir}/src/main/provisio")
    protected File descriptorDirectory;

    protected ProvisioArtifact projectArtifact() {
        ProvisioArtifact jarArtifact = null;
        Artifact projectArtifact = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)this.project.getArtifact());
        if (projectArtifact.getFile() != null && projectArtifact.getFile().getName().endsWith(".jar") && projectArtifact.getFile().exists()) {
            jarArtifact = new ProvisioArtifact(String.valueOf(this.project.getGroupId()) + ":" + this.project.getArtifactId() + ":" + this.project.getVersion()).setFile(projectArtifact.getFile());
        }
        return jarArtifact;
    }

    protected ArtifactSet getRuntimeClasspathAsArtifactSet() {
        ArtifactSet artifactSet = new ArtifactSet();
        for (Artifact mavenArtifact : this.resolveRuntimeScopeTransitively()) {
            artifactSet.addArtifact(new ProvisioArtifact(mavenArtifact));
        }
        return artifactSet;
    }

    private List<Artifact> resolveRuntimeScopeTransitively() {
        ScopeDependencyFilter runtimeFilter = new ScopeDependencyFilter(new String[]{"system", "provided", "test"});
        List dependencies = this.project.getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)this.repositorySystemSession.getArtifactTypeRegistry())).filter(d -> !"test".equals(d.getScope())).collect(Collectors.toList());
        List managedDependencies = Collections.emptyList();
        if (this.project.getDependencyManagement() != null) {
            managedDependencies = this.project.getDependencyManagement().getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)this.repositorySystemSession.getArtifactTypeRegistry())).collect(Collectors.toList());
        }
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)this.project.getArtifact()));
        collectRequest.setRepositories(this.project.getRemoteProjectRepositories());
        collectRequest.setDependencies(dependencies);
        collectRequest.setManagedDependencies(managedDependencies);
        DependencyRequest request = new DependencyRequest(collectRequest, (DependencyFilter)runtimeFilter);
        try {
            DependencyResult result = this.repositorySystem.resolveDependencies(this.repositorySystemSession, request);
            if (this.logger.isDebugEnabled() && result.getRoot() != null) {
                this.logger.debug("BaseMojo -- Collection result for {}", (Object)request.getCollectRequest());
                result.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(arg_0 -> ((Logger)this.logger).debug(arg_0)));
            }
            return result.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
        }
        catch (DependencyResolutionException e) {
            this.logger.error("Failed to resolve runtime dependencies", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected ProvisioningRequest getRequest(Runtime runtime) {
        ProvisioningRequest request = new ProvisioningRequest();
        request.setRuntimeDescriptor(runtime);
        request.setVariables(runtime.getVariables());
        request.setManagedDependencies(this.provisio.getManagedDependencies(this.project));
        return request;
    }

    protected void checkDuplicates(List<ProvisioArtifact> artifacts) throws MojoFailureException {
        HashMap grouped = new HashMap();
        for (ProvisioArtifact artifact : artifacts) {
            String key = artifact.toVersionlessCoordinate();
            if (!grouped.containsKey(key)) {
                grouped.put(key, new HashSet());
            }
            ((Set)grouped.get(key)).add(String.valueOf(key) + ":" + artifact.getVersion());
        }
        List duplicates = grouped.values().stream().filter(strings -> strings.size() > 1).map(strings -> String.join((CharSequence)", ", strings)).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new MojoFailureException("Found different versions of the same dependency: " + String.join((CharSequence)", ", duplicates));
        }
    }

    protected List<Dependency> getDependencies(List<ProvisioArtifact> artifacts) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (ProvisioArtifact artifact : artifacts) {
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getVersion());
            if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
                dependency.setClassifier(artifact.getClassifier());
            }
            if (artifact.getExtension() != null && !artifact.getExtension().isEmpty() && !artifact.getExtension().equals("jar")) {
                dependency.setType(artifact.getExtension());
            }
            dependencies.add(dependency);
        }
        return dependencies;
    }

    protected void mergeDependencies(Model model, List<Dependency> dependencies) {
        for (Dependency dependency : model.getDependencies()) {
            if (dependency.getScope() == null || dependency.getScope().equals("compile")) continue;
            dependencies.add(dependency);
        }
        Comparator<Dependency> comparator = Comparator.comparing(Dependency::getScope, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Dependency::getGroupId).thenComparing(Dependency::getArtifactId).thenComparing(Dependency::getVersion, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Dependency::getClassifier, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Dependency::getType, Comparator.nullsFirst(Comparator.naturalOrder()));
        TreeSet<Dependency> sorted = new TreeSet<Dependency>(comparator);
        sorted.addAll(dependencies);
        model.setDependencies(new ArrayList<Dependency>(sorted));
    }
}

