/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.maven.plugins.provisio;

import ca.vanzyl.maven.plugins.provisio.Provisio;
import ca.vanzyl.provisio.model.Runtime;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Singleton
@Named(value="ProvisioningLifecycleParticipant")
public class ProvisioningLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String DEFAULT_DESCRIPTOR_DIRECTORY = "src/main/provisio";
    private static final String DESCRIPTOR_DIRECTORY_CONFIG_ELEMENT = "descriptorDirectory";
    private final Provisio provisio;

    @Inject
    public ProvisioningLifecycleParticipant(Provisio provisio) {
        this.provisio = provisio;
    }

    protected String getPluginId() {
        return "provisio-maven-plugin";
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        for (MavenProject project : session.getProjects()) {
            projectMap.put(String.valueOf(project.getGroupId()) + ":" + project.getArtifactId(), project);
        }
        for (MavenProject project : session.getProjects()) {
            for (Plugin plugin : project.getBuild().getPlugins()) {
                Set<String> dependenciesInGAForm;
                if (!plugin.getArtifactId().equals(this.getPluginId()) || (dependenciesInGAForm = this.gleanDependenciesFromExternalResource(session, project, plugin)) == null) continue;
                for (String dependencyInGAForm : dependenciesInGAForm) {
                    if (!projectMap.containsKey(dependencyInGAForm)) continue;
                    MavenProject dependentProject = (MavenProject)projectMap.get(dependencyInGAForm);
                    Dependency dependency = new Dependency();
                    dependency.setGroupId(dependentProject.getGroupId());
                    dependency.setArtifactId(dependentProject.getArtifactId());
                    dependency.setVersion(dependentProject.getVersion());
                    dependency.setType(dependentProject.getPackaging());
                    dependency.setScope("provided");
                    project.getDependencies().add(dependency);
                }
            }
        }
    }

    protected Set<String> gleanDependenciesFromExternalResource(MavenSession session, MavenProject project, Plugin plugin) throws MavenExecutionException {
        Xpp3Dom configuration = this.getMojoConfiguration(plugin);
        File descriptorDirectory = configuration != null && configuration.getChild(DESCRIPTOR_DIRECTORY_CONFIG_ELEMENT) != null ? new File(project.getBasedir(), configuration.getChild(DESCRIPTOR_DIRECTORY_CONFIG_ELEMENT).getValue()) : new File(project.getBasedir(), DEFAULT_DESCRIPTOR_DIRECTORY);
        HashSet<String> dependencyCoordinatesInVersionlessForm = new HashSet<String>();
        List<Runtime> runtimes = this.provisio.findDescriptorsInFileSystem(descriptorDirectory, project);
        for (Runtime runtime : runtimes) {
            dependencyCoordinatesInVersionlessForm.addAll(runtime.getGAsOfArtifacts());
        }
        return dependencyCoordinatesInVersionlessForm;
    }

    protected Xpp3Dom getMojoConfiguration(Plugin plugin) {
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration == null && !plugin.getExecutions().isEmpty()) {
            configuration = (Xpp3Dom)((PluginExecution)plugin.getExecutions().get(0)).getConfiguration();
        }
        return configuration;
    }
}

