/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.extension.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JspTagLifecycle {
    private static Log log = LogFactory.getLog((Class)JspTagLifecycle.class);
    protected PageContext pageContext;
    private Tag tag;
    private List interceptors;

    public JspTagLifecycle(PageContext thePageContext, Tag theTag) {
        if (thePageContext == null || theTag == null) {
            throw new NullPointerException();
        }
        this.tag = theTag;
        this.pageContext = thePageContext;
        this.tag.setPageContext(this.pageContext);
    }

    public void addInterceptor(Interceptor theInterceptor) {
        if (theInterceptor == null) {
            throw new NullPointerException();
        }
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        this.interceptors.add(theInterceptor);
    }

    public JspTagLifecycle addNestedTag(Tag theNestedTag) {
        if (theNestedTag == null) {
            throw new NullPointerException();
        }
        JspTagLifecycle lifecycle = new JspTagLifecycle(this.pageContext, theNestedTag);
        theNestedTag.setParent(this.tag);
        this.addInterceptor(new NestedTagInterceptor(lifecycle));
        return lifecycle;
    }

    public void addNestedText(String theNestedText) {
        if (theNestedText == null) {
            throw new NullPointerException();
        }
        this.addInterceptor(new NestedTextInterceptor(theNestedText));
    }

    public void expectBodyEvaluated() {
        this.addInterceptor(new ExpectBodyEvaluatedInterceptor(1));
    }

    public void expectBodyEvaluated(int theNumIterations) {
        this.addInterceptor(new ExpectBodyEvaluatedInterceptor(theNumIterations));
    }

    public void expectBodySkipped() {
        this.addInterceptor(new ExpectBodySkippedInterceptor());
    }

    public void expectScopedVariableExposed(String theName, Object[] theExpectedValues) {
        this.expectScopedVariableExposed(theName, theExpectedValues, 1);
    }

    public void expectScopedVariableExposed(String theName, Object[] theExpectedValues, int theScope) {
        if (theName == null || theExpectedValues == null) {
            throw new NullPointerException();
        }
        if (theExpectedValues.length == 0) {
            throw new IllegalArgumentException();
        }
        if (theScope != 1 && theScope != 2 && theScope != 3 && theScope != 4) {
            throw new IllegalArgumentException();
        }
        this.addInterceptor(new ExpectScopedVariableExposedInterceptor(theName, theExpectedValues, theScope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws JspException, IOException {
        if (this.tag instanceof TryCatchFinally) {
            TryCatchFinally tryCatchFinally = (TryCatchFinally)this.tag;
            try {
                this.invokeInternal();
            }
            catch (Throwable t1) {
                try {
                    tryCatchFinally.doCatch(t1);
                }
                catch (Throwable t2) {
                    throw new JspException(t2.getMessage());
                }
            }
            finally {
                tryCatchFinally.doFinally();
            }
        } else {
            this.invokeInternal();
        }
    }

    private void fireEvalBody(int theIteration, BodyContent theBody) throws JspException, IOException {
        if (this.interceptors != null) {
            Iterator i = this.interceptors.iterator();
            while (i.hasNext()) {
                ((Interceptor)i.next()).evalBody(theIteration, theBody);
            }
        }
    }

    private void fireSkipBody() {
        if (this.interceptors != null) {
            Iterator i = this.interceptors.iterator();
            while (i.hasNext()) {
                ((Interceptor)i.next()).skipBody();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeInternal() throws JspException, IOException {
        int status;
        block14: {
            status = this.tag.doStartTag();
            if (this.tag instanceof IterationTag) {
                if (status != 0) {
                    BodyContent body = null;
                    try {
                        IterationTag iterationTag = (IterationTag)this.tag;
                        if (status == 2 && this.tag instanceof BodyTag) {
                            BodyTag bodyTag = (BodyTag)this.tag;
                            body = this.pageContext.pushBody();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Pushed body content [" + body.getString() + "]"));
                            }
                            bodyTag.setBodyContent(body);
                            bodyTag.doInitBody();
                        }
                        int iteration = 0;
                        do {
                            this.fireEvalBody(iteration, body);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Body evaluated for the [" + iteration + "] time"));
                            }
                            status = iterationTag.doAfterBody();
                            ++iteration;
                        } while (status == 2);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Body skipped");
                        }
                        this.fireSkipBody();
                        Object var6_6 = null;
                        if (body == null) break block14;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        if (body != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Popping body content [" + body.getString() + "]"));
                            }
                            this.pageContext.popBody();
                            body = null;
                        }
                        throw throwable;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Popping body content [" + body.getString() + "]"));
                    }
                    this.pageContext.popBody();
                    body = null;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Body skipped");
                    }
                    this.fireSkipBody();
                }
            }
        }
        status = this.tag.doEndTag();
    }

    private class NestedTextInterceptor
    extends Interceptor {
        private String text;

        public NestedTextInterceptor(String theText) {
            this.text = theText;
        }

        public void evalBody(int theIteration, BodyContent theBody) throws IOException {
            if (theBody != null) {
                theBody.print(this.text);
            } else {
                JspTagLifecycle.this.pageContext.getOut().print(this.text);
            }
        }
    }

    private class NestedTagInterceptor
    extends Interceptor {
        private JspTagLifecycle lifecycle;

        public NestedTagInterceptor(JspTagLifecycle theLifecycle) {
            this.lifecycle = theLifecycle;
        }

        public void evalBody(int theIteration, BodyContent theBody) throws JspException, IOException {
            this.lifecycle.invoke();
        }
    }

    private class ExpectScopedVariableExposedInterceptor
    extends Interceptor {
        private String name;
        private Object[] expectedValues;
        private int scope;

        public ExpectScopedVariableExposedInterceptor(String theName, Object[] theExpectedValues, int theScope) {
            this.name = theName;
            this.expectedValues = theExpectedValues;
            this.scope = theScope;
        }

        public void evalBody(int theIteration, BodyContent theBody) {
            Assert.assertEquals((Object)this.expectedValues[theIteration], (Object)JspTagLifecycle.this.pageContext.getAttribute(this.name, this.scope));
        }
    }

    private static class ExpectBodySkippedInterceptor
    extends Interceptor {
        private ExpectBodySkippedInterceptor() {
        }

        public void evalBody(int theIteration, BodyContent theBody) {
            Assert.fail((String)"Tag body should have been skipped");
        }
    }

    private static class ExpectBodyEvaluatedInterceptor
    extends Interceptor {
        private int actualNumIterations;
        private int expectedNumIterations;

        public ExpectBodyEvaluatedInterceptor(int theNumIterations) {
            this.expectedNumIterations = theNumIterations;
        }

        public void evalBody(int theIteration, BodyContent theBody) {
            ++this.actualNumIterations;
            if (this.actualNumIterations > this.expectedNumIterations) {
                Assert.fail((String)("Expected " + this.expectedNumIterations + " iterations, but was " + this.actualNumIterations));
            }
        }

        public void skipBody() {
            if (this.actualNumIterations < this.expectedNumIterations) {
                Assert.fail((String)("Expected " + this.expectedNumIterations + " iterations, but was " + this.actualNumIterations));
            }
        }
    }

    public static abstract class Interceptor {
        public void evalBody(int theIteration, BodyContent theBody) throws JspException, IOException {
        }

        public void skipBody() {
        }
    }
}

