/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server.runner;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.cactus.internal.configuration.ConfigurationInitializer;
import org.apache.cactus.internal.server.runner.WebappTestRunner;
import org.apache.cactus.internal.server.runner.XMLFormatter;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ServletTestRunner
extends HttpServlet {
    private static final String HTTP_SUITE_PARAM = "suite";
    private static final String HTTP_TRANSFORM_PARAM = "transform";
    private static final String HTTP_XSL_PARAM = "xsl";
    private static final String XSL_STYLESHEET_PARAM = "xsl-stylesheet";
    private static final String ENCODING_PARAM = "encoding";
    private Object transformer = null;
    private boolean canSetSystemProperty = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void init() throws ServletException {
        ConfigurationInitializer.initialize(true);
        String xslStylesheetParam = this.getInitParameter(XSL_STYLESHEET_PARAM);
        if (xslStylesheetParam != null) {
            InputStream xslStylesheet = this.getServletContext().getResourceAsStream(xslStylesheetParam);
            if (xslStylesheet != null) {
                try {
                    Class<?> transformerClass = Class.forName("org.apache.cactus.internal.server.runner.XMLTransformer");
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.io.InputStream");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor<?> transformerCtor = transformerClass.getConstructor(classArray);
                    this.transformer = transformerCtor.newInstance(xslStylesheet);
                }
                catch (Throwable t) {
                    this.log("Could not instantiate XMLTransformer - will not perform server-side XSLT transformations", t);
                }
            } else {
                throw new UnavailableException("The initialization parameter 'xsl-stylesheet' does not refer to an existing resource");
            }
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        HttpServletResponse httpServletResponse2 = httpServletResponse;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest2, (Object)httpServletResponse2);
        ServletTestRunner.doGet_aroundBody1$advice(this, httpServletRequest2, httpServletResponse2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private void setSystemProperties(HttpServletRequest theRequest) {
        String contextURL = System.getProperty("cactus.contextURL");
        if (contextURL == null && this.canSetSystemProperty) {
            try {
                System.setProperty("cactus.contextURL", "http://" + theRequest.getServerName() + ":" + theRequest.getServerPort() + theRequest.getContextPath());
            }
            catch (SecurityException se) {
                this.log("Could not set the Cactus context URL as system property, you will have to include a Cactus properties file in the class path of the web application", se);
                this.canSetSystemProperty = false;
            }
        }
    }

    protected String run(String theSuiteClassName, String theXslFileName, String theEncoding) throws ServletException {
        TestResult result = new TestResult();
        XMLFormatter formatter = new XMLFormatter();
        formatter.setXslFileName(theXslFileName);
        formatter.setSuiteClassName(theSuiteClassName);
        if (theEncoding != null) {
            formatter.setEncoding(theEncoding);
        }
        result.addListener((TestListener)formatter);
        long startTime = System.currentTimeMillis();
        WebappTestRunner testRunner = new WebappTestRunner();
        Test suite = testRunner.getTest(theSuiteClassName);
        if (suite == null) {
            throw new ServletException("Failed to load test suite [" + theSuiteClassName + "], Reason is [" + testRunner.getErrorMessage() + "]");
        }
        suite.run(result);
        long endTime = System.currentTimeMillis();
        formatter.setTotalDuration(endTime - startTime);
        return formatter.toXML(result);
    }

    static {
        Factory factory = new Factory("ServletTestRunner.java", Class.forName("org.apache.cactus.server.runner.ServletTestRunner"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-doGet-org.apache.cactus.server.runner.ServletTestRunner-javax.servlet.http.HttpServletRequest:javax.servlet.http.HttpServletResponse:-theRequest:theResponse:-javax.servlet.ServletException:java.io.IOException:-void-"), 160);
    }

    private static final /* synthetic */ void doGet_aroundBody0(ServletTestRunner this_, HttpServletRequest theRequest, HttpServletResponse theResponse, JoinPoint joinPoint) {
        String suiteClassName = theRequest.getParameter(HTTP_SUITE_PARAM);
        this_.setSystemProperties(theRequest);
        if (suiteClassName == null) {
            throw new ServletException("Missing HTTP parameter [suite] in request");
        }
        String xslParam = theRequest.getParameter(HTTP_XSL_PARAM);
        String transformParam = theRequest.getParameter(HTTP_TRANSFORM_PARAM);
        String encoding = theRequest.getParameter(ENCODING_PARAM);
        String xml = this_.run(suiteClassName, xslParam, encoding);
        if (transformParam != null && this_.transformer != null) {
            try {
                Method getContentTypeMethod = this_.transformer.getClass().getMethod("getContentType", new Class[0]);
                theResponse.setContentType((String)getContentTypeMethod.invoke(this_.transformer, new Object[0]));
                PrintWriter out = theResponse.getWriter();
                Class<?> clazz = this_.transformer.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.io.Reader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.io.Writer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                Method transformMethod = clazz.getMethod(HTTP_TRANSFORM_PARAM, classArray);
                transformMethod.invoke(this_.transformer, new StringReader(xml), out);
            }
            catch (Exception e) {
                throw new ServletException("Problem applying the XSLT transformation", (Throwable)e);
            }
        }
        theResponse.setContentType("text/xml");
        PrintWriter pw = theResponse.getWriter();
        pw.println(xml);
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object doGet_aroundBody1$advice(ServletTestRunner this_, HttpServletRequest ajc_aroundClosure, HttpServletResponse thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            ServletTestRunner.doGet_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        AroundClosure aroundClosure3 = aroundClosure;
        ServletTestRunner.doGet_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }
}

