/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.response;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.preprocess.ContentModifier;

public class BinaryReplacementContentModifier
implements ContentModifier {
    public static final Set<MediaType> BINARY_ENUM_TYPES = new HashSet<MediaType>();

    public byte[] modifyContent(byte[] originalContent, MediaType contentType) {
        if (originalContent.length > 0 && contentType != null) {
            for (MediaType type : BINARY_ENUM_TYPES) {
                if (!contentType.includes(type)) continue;
                return this.replacementText();
            }
        }
        return originalContent;
    }

    public byte[] replacementText() {
        return "<binary>".getBytes(StandardCharsets.UTF_8);
    }

    static {
        BINARY_ENUM_TYPES.add(MediaType.valueOf((String)"application/pdf"));
        BINARY_ENUM_TYPES.add(MediaType.APPLICATION_OCTET_STREAM);
        BINARY_ENUM_TYPES.add(MediaType.IMAGE_JPEG);
        BINARY_ENUM_TYPES.add(MediaType.IMAGE_GIF);
        BINARY_ENUM_TYPES.add(MediaType.IMAGE_PNG);
    }
}

