/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.ConstraintAndGroupDescriptionResolver;
import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.constraints.HumanReadableConstraintResolver;
import capital.scalable.restdocs.constraints.SkippableConstraintResolver;
import capital.scalable.restdocs.util.ObjectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;
import org.springframework.restdocs.constraints.ConstraintDescriptions;
import org.springframework.restdocs.constraints.ConstraintResolver;
import org.springframework.restdocs.constraints.ResourceBundleConstraintDescriptionResolver;
import org.springframework.restdocs.constraints.ValidatorConstraintResolver;
import org.springframework.util.ReflectionUtils;

public class ConstraintReaderImpl
implements ConstraintReader {
    private ConstraintAndGroupDescriptionResolver constraintDescriptionResolver = new ConstraintAndGroupDescriptionResolver((ConstraintDescriptionResolver)new ResourceBundleConstraintDescriptionResolver());
    private final SkippableConstraintResolver skippableConstraintResolver = new SkippableConstraintResolver((ConstraintResolver)new ValidatorConstraintResolver(), this.constraintDescriptionResolver);
    private ConstraintResolver constraintResolver = new HumanReadableConstraintResolver(this.skippableConstraintResolver);

    @Override
    public List<String> getOptionalMessages(Class<?> javaBaseClass, String javaFieldName) {
        return this.skippableConstraintResolver.getOptionalMessages(javaFieldName, javaBaseClass);
    }

    @Override
    public boolean isMandatory(Class<?> annotation) {
        return ArrayUtils.contains((Object[])SkippableConstraintResolver.MANDATORY_VALUE_ANNOTATIONS, annotation);
    }

    @Override
    public List<String> getConstraintMessages(Class<?> javaBaseClass, String javaFieldName) {
        ConstraintDescriptions constraints = new ConstraintDescriptions(javaBaseClass, this.constraintResolver, (ConstraintDescriptionResolver)this.constraintDescriptionResolver);
        ArrayList<String> constraintMessages = new ArrayList<String>();
        constraintMessages.addAll(constraints.descriptionsForProperty(javaFieldName));
        constraintMessages.addAll(this.getEnumConstraintMessage(javaBaseClass, javaFieldName));
        return constraintMessages;
    }

    @Override
    public List<String> getConstraintMessages(MethodParameter param) {
        return new ArrayList<String>();
    }

    private List<String> getEnumConstraintMessage(Class<?> javaBaseClass, String javaFieldName) {
        Field field = ReflectionUtils.findField(javaBaseClass, (String)javaFieldName);
        if (field == null) {
            return Collections.emptyList();
        }
        Class<?> rawClass = field.getType();
        if (!rawClass.isEnum()) {
            return Collections.emptyList();
        }
        Class<?> enumClass = rawClass;
        String value = ObjectUtil.arrayToString(enumClass.getEnumConstants());
        String enumName = enumClass.getCanonicalName();
        String message = this.constraintDescriptionResolver.resolveDescription(new Constraint(enumName, Collections.singletonMap("value", value)));
        if (StringUtils.isBlank((CharSequence)message) || message.equals(enumName)) {
            message = "Must be one of " + value;
        }
        return Collections.singletonList(message);
    }
}

