/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.GroupDescriptionResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintResolver;

class SkippableConstraintResolver
implements ConstraintResolver {
    public static final Class<?>[] MANDATORY_VALUE_ANNOTATIONS = new Class[]{NotNull.class, NotEmpty.class, NotBlank.class};
    private final ConstraintResolver delegate;
    private GroupDescriptionResolver descriptionResolver;
    private final Collection<String> skippableConstraints;

    public SkippableConstraintResolver(ConstraintResolver delegate, GroupDescriptionResolver descriptionResolver) {
        this.delegate = delegate;
        this.descriptionResolver = descriptionResolver;
        this.skippableConstraints = new ArrayList<String>();
        for (Class<?> a : MANDATORY_VALUE_ANNOTATIONS) {
            this.skippableConstraints.add(a.getCanonicalName());
        }
    }

    private boolean isSkippable(Constraint constraint) {
        return this.skippableConstraints.contains(constraint.getName());
    }

    public List<Constraint> resolveForProperty(String property, Class<?> clazz) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : this.delegate.resolveForProperty(property, clazz)) {
            if (this.isSkippable(constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    public List<String> getOptionalMessages(String property, Class<?> clazz) {
        ArrayList<String> result = new ArrayList<String>();
        List constraints = this.delegate.resolveForProperty(property, clazz);
        String defaultOptional = null;
        for (Constraint constraint : constraints) {
            if (!this.isSkippable(constraint)) continue;
            List<Class> groups = this.getGroups(constraint);
            if (groups.isEmpty()) {
                defaultOptional = "false";
                continue;
            }
            for (Class group : groups) {
                result.add(this.mandatoryForGroup(group));
            }
        }
        Collections.sort(result);
        if (defaultOptional != null) {
            result.add(0, defaultOptional);
        }
        return result;
    }

    private List<Class> getGroups(Constraint constraint) {
        return this.descriptionResolver.getGroups(constraint);
    }

    private String mandatoryForGroup(Class group) {
        return this.descriptionResolver.resolveGroupDescription(group, "false");
    }
}

