/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.jackson.InternalFieldInfo;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.util.FieldUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.snippet.Attributes;

public class FieldDocumentationVisitorContext {
    private final List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
    private JavadocReader javadocReader;
    private ConstraintReader constraintReader;

    public FieldDocumentationVisitorContext(JavadocReader javadocReader, ConstraintReader constraintReader) {
        this.javadocReader = javadocReader;
        this.constraintReader = constraintReader;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public void addField(InternalFieldInfo info, String jsonType) {
        Class<?> javaFieldClass = info.getJavaBaseClass();
        String javaFieldName = info.getJavaFieldName();
        String comment = this.resolveComment(javaFieldClass, javaFieldName);
        String jsonFieldPath = info.getJsonFieldPath();
        FieldDescriptor fieldDescriptor = (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)jsonFieldPath).type((Object)jsonType).description((Object)comment);
        Attributes.Attribute constraints = this.constraintAttribute(javaFieldClass, javaFieldName);
        Attributes.Attribute optionals = this.optionalAttribute(javaFieldClass, javaFieldName);
        fieldDescriptor.attributes(new Attributes.Attribute[]{constraints, optionals});
        this.fields.add(fieldDescriptor);
    }

    private String resolveComment(Class<?> javaFieldClass, String javaFieldName) {
        String comment = this.javadocReader.resolveFieldComment(javaFieldClass, javaFieldName);
        if (StringUtils.isBlank((CharSequence)comment)) {
            comment = this.javadocReader.resolveMethodComment(javaFieldClass, javaFieldName);
        }
        if (StringUtils.isBlank((CharSequence)comment) && FieldUtil.isGetter(javaFieldName)) {
            comment = this.javadocReader.resolveFieldComment(javaFieldClass, FieldUtil.fromGetter(javaFieldName));
        }
        return comment;
    }

    private Attributes.Attribute constraintAttribute(Class<?> javaBaseClass, String javaFieldName) {
        return new Attributes.Attribute("constraints", this.resolveConstraintDescriptions(javaBaseClass, javaFieldName));
    }

    private Attributes.Attribute optionalAttribute(Class<?> javaBaseClass, String javaFieldName) {
        return new Attributes.Attribute("optionals", this.resolveOptionalMessages(javaBaseClass, javaFieldName));
    }

    private List<String> resolveOptionalMessages(Class<?> javaBaseClass, String javaFieldName) {
        ArrayList<String> optionalMessages = new ArrayList<String>();
        optionalMessages.addAll(this.constraintReader.getOptionalMessages(javaBaseClass, javaFieldName));
        if (optionalMessages.isEmpty() && FieldUtil.isGetter(javaFieldName)) {
            optionalMessages.addAll(this.constraintReader.getOptionalMessages(javaBaseClass, FieldUtil.fromGetter(javaFieldName)));
        }
        if (!optionalMessages.contains("false") && !optionalMessages.contains("true")) {
            optionalMessages.add(0, "true");
        }
        return optionalMessages;
    }

    private List<String> resolveConstraintDescriptions(Class<?> javaBaseClass, String javaFieldName) {
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.addAll(this.constraintReader.getConstraintMessages(javaBaseClass, javaFieldName));
        if (descriptions.isEmpty() && FieldUtil.isGetter(javaFieldName)) {
            descriptions.addAll(this.constraintReader.getConstraintMessages(javaBaseClass, FieldUtil.fromGetter(javaFieldName)));
        }
        return descriptions;
    }
}

