/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.jackson.FieldDocumentationArrayVisitor;
import capital.scalable.restdocs.jackson.FieldDocumentationObjectVisitor;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorContext;
import capital.scalable.restdocs.jackson.InternalFieldInfo;
import capital.scalable.restdocs.javadoc.JavadocReader;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;

public class FieldDocumentationVisitorWrapper
implements JsonFormatVisitorWrapper {
    private SerializerProvider provider;
    private final FieldDocumentationVisitorContext context;
    private final String path;
    private final InternalFieldInfo fieldInfo;

    FieldDocumentationVisitorWrapper(FieldDocumentationVisitorContext context, String path, InternalFieldInfo fieldInfo) {
        this(null, context, path, fieldInfo);
    }

    FieldDocumentationVisitorWrapper(SerializerProvider provider, FieldDocumentationVisitorContext context, String path, InternalFieldInfo fieldInfo) {
        this.provider = provider;
        this.context = context;
        this.path = path;
        this.fieldInfo = fieldInfo;
    }

    public static FieldDocumentationVisitorWrapper create(JavadocReader javadocReader, ConstraintReader constraintReader) {
        return new FieldDocumentationVisitorWrapper(new FieldDocumentationVisitorContext(javadocReader, constraintReader), "", null);
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider provider) {
        this.provider = provider;
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Object");
        if (this.shouldExpand()) {
            return new FieldDocumentationObjectVisitor(this.provider, this.context, this.path);
        }
        return new JsonObjectFormatVisitor.Base();
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Array");
        if (this.shouldExpand()) {
            return new FieldDocumentationArrayVisitor(this.provider, this.context, this.path);
        }
        return new JsonArrayFormatVisitor.Base();
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("String");
        return new JsonStringFormatVisitor.Base();
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Decimal");
        return new JsonNumberFormatVisitor.Base();
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Integer");
        return new JsonIntegerFormatVisitor.Base();
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Boolean");
        return new JsonBooleanFormatVisitor.Base();
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("null");
        return new JsonNullFormatVisitor.Base();
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Var");
        return new JsonAnyFormatVisitor.Base();
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Map");
        return new JsonMapFormatVisitor.Base(this.provider);
    }

    public FieldDocumentationVisitorContext getContext() {
        return this.context;
    }

    private void addFieldIfPresent(String jsonType) {
        if (this.fieldInfo != null) {
            this.context.addField(this.fieldInfo, jsonType);
        }
    }

    private boolean shouldExpand() {
        return this.fieldInfo == null || this.fieldInfo.shouldExpand();
    }
}

