/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.javadoc;

import capital.scalable.restdocs.javadoc.ClassJavadoc;
import capital.scalable.restdocs.javadoc.JavadocReader;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JavadocReaderImpl
implements JavadocReader {
    private static final Logger log = LoggerFactory.getLogger(JavadocReader.class);
    private final Map<String, ClassJavadoc> classCache = new ConcurrentHashMap<String, ClassJavadoc>();
    private final ObjectMapper mapper = new ObjectMapper();
    private final File javadocJsonDir;

    public JavadocReaderImpl() {
        this(null);
    }

    public JavadocReaderImpl(String javadocJsonDir) {
        this.javadocJsonDir = javadocJsonDir != null ? new File(javadocJsonDir).getAbsoluteFile() : this.systemPropertyJavadocJsonDir();
        this.mapper.setVisibility(this.mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }

    private ClassJavadoc getClass(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        String packageDir = packageName.replace(".", File.separator);
        String className = clazz.getCanonicalName().replaceAll(packageName + "\\.?", "");
        String fileName = packageDir + "/" + className + ".json";
        ClassJavadoc classJavadoc = this.classCache.get(fileName);
        if (classJavadoc != null) {
            return classJavadoc;
        }
        try {
            File docSource = this.makeRelativeToConfiguredJavaDocJsonDir(new File(fileName));
            classJavadoc = (ClassJavadoc)this.mapper.readerFor(ClassJavadoc.class).readValue(docSource);
        }
        catch (FileNotFoundException e) {
            log.warn("No JavaDoc found for {} at {}", (Object)clazz.getCanonicalName(), (Object)fileName);
            classJavadoc = new ClassJavadoc();
        }
        catch (IOException e) {
            log.error("Problem reading file {}", (Object)fileName, (Object)e);
            classJavadoc = new ClassJavadoc();
        }
        this.classCache.put(fileName, classJavadoc);
        return classJavadoc;
    }

    @Override
    public String resolveFieldComment(Class<?> javaBaseClass, String javaFieldName) {
        return this.getClass(javaBaseClass).getFieldComment(javaFieldName);
    }

    @Override
    public String resolveMethodComment(Class<?> javaBaseClass, String javaMethodName) {
        return this.getClass(javaBaseClass).getMethodComment(javaMethodName);
    }

    @Override
    public String resolveMethodParameterComment(Class<?> javaBaseClass, String javaMethodName, String javaParameterName) {
        return this.getClass(javaBaseClass).getMethodParameterComment(javaMethodName, javaParameterName);
    }

    private File makeRelativeToConfiguredJavaDocJsonDir(File outputFile) {
        if (this.javadocJsonDir != null) {
            return new File(this.javadocJsonDir, outputFile.getPath());
        }
        return new File(outputFile.getPath());
    }

    private File systemPropertyJavadocJsonDir() {
        String outputDir = System.getProperties().getProperty("org.springframework.restdocs.javadocJsonDir");
        if (StringUtils.hasText((String)outputDir)) {
            return new File(outputDir).getAbsoluteFile();
        }
        return null;
    }
}

