/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.misc;

import capital.scalable.restdocs.OperationAttributeHelper;
import java.util.HashMap;
import java.util.Map;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.TemplatedSnippet;

public class AuthorizationSnippet
extends TemplatedSnippet {
    private final String defaultAuthorization;

    public AuthorizationSnippet(String defaultAuthorization) {
        super("authorization", null);
        this.defaultAuthorization = defaultAuthorization;
    }

    protected Map<String, Object> createModel(Operation operation) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("authorization", this.authorizationDescription(operation));
        return model;
    }

    private String authorizationDescription(Operation operation) {
        String requestAuthorization = OperationAttributeHelper.getAuthorization(operation);
        if (requestAuthorization != null) {
            return requestAuthorization;
        }
        return this.defaultAuthorization;
    }

    public static MockHttpServletRequest documentAuthorization(MockHttpServletRequest request, String authorization) {
        OperationAttributeHelper.setAuthorization(request, authorization);
        return request;
    }
}

