/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.MethodParameterConstraintResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Constraint;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.constraints.ValidatorConstraintResolver;

public class MethodParameterValidatorConstraintResolver
extends ValidatorConstraintResolver
implements MethodParameterConstraintResolver {
    @Override
    public List<org.springframework.restdocs.constraints.Constraint> resolveForParameter(MethodParameter param) {
        ArrayList<org.springframework.restdocs.constraints.Constraint> constraints = new ArrayList<org.springframework.restdocs.constraints.Constraint>();
        for (Annotation annot : param.getParameterAnnotations()) {
            Class<? extends Annotation> type = annot.annotationType();
            if (type.getAnnotation(Constraint.class) == null) continue;
            org.springframework.restdocs.constraints.Constraint constraint = this.createConstraint(annot, type);
            constraints.add(constraint);
        }
        return constraints;
    }

    private org.springframework.restdocs.constraints.Constraint createConstraint(Annotation annot, Class<? extends Annotation> type) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        for (Method method : type.getDeclaredMethods()) {
            String methodName = method.getName();
            Object value = this.getAnnotValue(annot, method);
            configuration.put(methodName, value);
        }
        return new org.springframework.restdocs.constraints.Constraint(type.getName(), configuration);
    }

    private Object getAnnotValue(Annotation annot, Method method) {
        try {
            return method.invoke((Object)annot, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

