/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorWrapper;
import capital.scalable.restdocs.javadoc.JavadocReader;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.restdocs.payload.FieldDescriptor;

public class FieldDocumentationGenerator {
    private final ObjectWriter writer;
    private final DeserializationConfig deserializationConfig;
    private final JavadocReader javadocReader;
    private final ConstraintReader constraintReader;

    public FieldDocumentationGenerator(ObjectWriter writer, DeserializationConfig deserializationConfig, JavadocReader javadocReader, ConstraintReader constraintReader) {
        this.writer = writer;
        this.deserializationConfig = deserializationConfig;
        this.javadocReader = javadocReader;
        this.constraintReader = constraintReader;
    }

    public List<FieldDescriptor> generateDocumentation(Type type, TypeFactory typeFactory) throws JsonMappingException {
        return this.generateDocumentation(typeFactory.constructType(type));
    }

    public List<FieldDescriptor> generateDocumentation(JavaType type) throws JsonMappingException {
        FieldDocumentationVisitorWrapper visitorWrapper = FieldDocumentationVisitorWrapper.create(this.javadocReader, this.constraintReader, this.deserializationConfig);
        this.writer.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)visitorWrapper);
        return visitorWrapper.getContext().getFields();
    }
}

