/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.jackson.FieldDocumentationVisitorContext;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorWrapper;
import capital.scalable.restdocs.jackson.InternalFieldInfo;
import capital.scalable.restdocs.jackson.RestdocsNotExpanded;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import java.util.Set;

public class FieldDocumentationObjectVisitor
extends JsonObjectFormatVisitor.Base {
    private final FieldDocumentationVisitorContext context;
    private final String path;
    private final Set<JavaType> visited;

    public FieldDocumentationObjectVisitor(SerializerProvider provider, FieldDocumentationVisitorContext context, String path, Set<JavaType> visited) {
        super(provider);
        this.context = context;
        this.path = path;
        this.visited = visited;
    }

    public void optionalProperty(BeanProperty prop) throws JsonMappingException {
        String jsonName = prop.getName();
        String fieldName = prop.getMember().getName();
        JavaType type = prop.getType();
        if (type == null) {
            throw new IllegalStateException("Missing type for property '" + jsonName + "', " + "field '" + fieldName + "'");
        }
        JsonSerializer<?> ser = this.getSer(prop);
        if (ser == null) {
            return;
        }
        String fieldPath = this.path + (this.path.isEmpty() ? "" : ".") + jsonName;
        Class javaBaseClass = prop.getMember().getDeclaringClass();
        boolean shouldExpand = this.shouldExpand(prop);
        InternalFieldInfo fieldInfo = new InternalFieldInfo(javaBaseClass, fieldName, fieldPath, shouldExpand);
        FieldDocumentationVisitorWrapper visitor = new FieldDocumentationVisitorWrapper(this.getProvider(), this.context, fieldPath, fieldInfo, this.visited);
        ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, type);
    }

    protected JsonSerializer<?> getSer(BeanProperty prop) throws JsonMappingException {
        JsonSerializer ser = null;
        if (prop instanceof BeanPropertyWriter) {
            ser = ((BeanPropertyWriter)prop).getSerializer();
        }
        if (ser == null) {
            ser = this.getProvider().findValueSerializer(prop.getType(), prop);
        }
        return ser;
    }

    private boolean shouldExpand(BeanProperty prop) {
        return prop.getMember().getAnnotation(RestdocsNotExpanded.class) == null;
    }
}

