/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.javadoc;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

class ClassJavadoc {
    private String comment;
    private Map<String, String> fields = new HashMap<String, String>();
    private Map<String, MethodJavadoc> methods = new HashMap<String, MethodJavadoc>();

    ClassJavadoc() {
    }

    public String getClassComment() {
        return this.comment;
    }

    public String getFieldComment(String fieldName) {
        return ClassJavadoc.trimToEmpty(this.fields.get(fieldName));
    }

    public String getMethodComment(String methodName) {
        MethodJavadoc methodJavadoc = this.methods.get(methodName);
        if (methodJavadoc != null) {
            return methodJavadoc.getComment();
        }
        return "";
    }

    public String getMethodTitle(String methodName) {
        MethodJavadoc methodJavadoc = this.methods.get(methodName);
        if (methodJavadoc != null) {
            return methodJavadoc.getTitle();
        }
        return "";
    }

    public String getMethodParameterComment(String methodName, String parameterName) {
        MethodJavadoc methodJavadoc = this.methods.get(methodName);
        if (methodJavadoc != null) {
            return methodJavadoc.getParameterComment(parameterName);
        }
        return "";
    }

    private static String trimToEmpty(String value) {
        return StringUtils.hasText((String)value) ? value : "";
    }

    static class MethodJavadoc {
        private String title;
        private String comment;
        private Map<String, String> parameters = new HashMap<String, String>();

        MethodJavadoc() {
        }

        public String getComment() {
            return ClassJavadoc.trimToEmpty(this.comment);
        }

        public String getParameterComment(String parameterName) {
            return ClassJavadoc.trimToEmpty(this.parameters.get(parameterName));
        }

        public String getTitle() {
            return ClassJavadoc.trimToEmpty(this.title);
        }
    }
}

