/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.javadoc;

public class JavadocUtil {
    private static String FORCED_LB = "__FLB__";
    private static String LB = "__LB__";

    private JavadocUtil() {
    }

    public static String convertFromJavadoc(String javadoc, String forcedLineBreak) {
        String converted = javadoc.toString().replace("\n", "").replace("<br/>", FORCED_LB).replace("<br>", FORCED_LB).replace("<p>", LB + LB).replace("</p>", LB + LB).replace("<ul>", LB).replace("</ul>", LB + LB).replace("<li>", LB + "- ").replace("</li>", "");
        if (converted.isEmpty()) {
            return "";
        }
        String res = JavadocUtil.trimAndFixLineBreak(converted, FORCED_LB, forcedLineBreak);
        res = JavadocUtil.trimAndFixLineBreak(res, LB, "\n");
        return res.toString();
    }

    private static String trimAndFixLineBreak(String text, String separator, String newSeparator) {
        StringBuilder res = new StringBuilder();
        for (String line : text.split(separator)) {
            res.append(line.trim()).append(newSeparator);
        }
        res.delete(res.lastIndexOf(newSeparator), res.length());
        return res.toString();
    }
}

