/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.section;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.SnippetRegistry;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.section.SectionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolverFactory;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.method.HandlerMethod;

public class SectionSnippet
extends TemplatedSnippet {
    public static final String SECTION = "auto-section";
    private final RestDocumentationContextPlaceholderResolverFactory placeholderResolverFactory = new RestDocumentationContextPlaceholderResolverFactory();
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");
    private final Collection<String> sectionNames;
    private final boolean skipEmpty;

    public SectionSnippet(Collection<String> sectionNames, boolean skipEmpty) {
        super(SECTION, null);
        this.sectionNames = sectionNames;
        this.skipEmpty = skipEmpty;
    }

    protected Map<String, Object> createModel(Operation operation) {
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        JavadocReader javadocReader = OperationAttributeHelper.getJavadocReader(operation);
        String title = this.resolveTitle(handlerMethod, javadocReader);
        String path = this.propertyPlaceholderHelper.replacePlaceholders(operation.getName(), this.placeholderResolverFactory.create(OperationAttributeHelper.getDocumentationContext(operation)));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("title", title);
        model.put("link", this.delimit(path));
        model.put("path", path);
        ArrayList<SectionSupport> sections = new ArrayList<SectionSupport>();
        model.put("sections", sections);
        for (String sectionName : this.sectionNames) {
            SectionSupport section = this.getSectionSnippet(operation, sectionName);
            if (section != null) {
                if (this.skipEmpty && !section.hasContent(operation)) continue;
                sections.add(section);
                continue;
            }
            System.out.println("Section snippet '" + sectionName + "' is configured to be " + "included in the section but no such snippet is present in configuration");
        }
        return model;
    }

    private String resolveTitle(HandlerMethod handlerMethod, JavadocReader javadocReader) {
        String title = javadocReader.resolveMethodTitle(handlerMethod.getBeanType(), handlerMethod.getMethod().getName());
        if (StringUtils.isBlank((CharSequence)title)) {
            title = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)org.springframework.util.StringUtils.capitalize((String)handlerMethod.getMethod().getName())), (char)' ');
        }
        return title;
    }

    private SectionSupport getSectionSnippet(Operation operation, String snippetName) {
        for (Snippet snippet : OperationAttributeHelper.getDefaultSnippets(operation)) {
            SectionSupport sectionSnippet;
            if (!(snippet instanceof SectionSupport) || !snippetName.equals((sectionSnippet = (SectionSupport)snippet).getFileName())) continue;
            return sectionSnippet;
        }
        return SnippetRegistry.getClassicSnippet(snippetName);
    }

    private String delimit(String value) {
        return value.replace("/", "-");
    }
}

