/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.snippet;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.javadoc.JavadocUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.web.method.HandlerMethod;

public abstract class StandardTableSnippet
extends TemplatedSnippet {
    protected StandardTableSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    protected Map<String, Object> createModel(Operation operation) {
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        List<FieldDescriptor> fieldDescriptors = Collections.emptyList();
        if (handlerMethod != null) {
            fieldDescriptors = this.createFieldDescriptors(operation, handlerMethod);
        }
        String forcedLineBreak = OperationAttributeHelper.determineForcedLineBreak(operation);
        return this.createModel(handlerMethod, fieldDescriptors, forcedLineBreak);
    }

    protected abstract Collection<FieldDescriptor> createFieldDescriptors(Operation var1, HandlerMethod var2);

    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod) {
    }

    private Map<String, Object> createModel(HandlerMethod handlerMethod, Collection<FieldDescriptor> fieldDescriptors, String forcedLineBreak) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        model.put("content", fields);
        for (FieldDescriptor descriptor : fieldDescriptors) {
            fields.add(this.createModelForDescriptor(descriptor, forcedLineBreak));
        }
        model.put("hasContent", !fieldDescriptors.isEmpty());
        model.put("noContent", fieldDescriptors.isEmpty());
        this.enrichModel(model, handlerMethod);
        return model;
    }

    protected Map<String, Object> createModelForDescriptor(FieldDescriptor descriptor, String forcedLineBreak) {
        String path = descriptor.getPath();
        String type = this.toString(descriptor.getType());
        String description = JavadocUtil.convertFromJavadoc(this.toString(descriptor.getDescription()), forcedLineBreak);
        String optional = this.resolveOptional(descriptor, forcedLineBreak);
        List<String> constraints = this.resolveConstraints(descriptor);
        description = this.joinAndFormat(description, constraints, forcedLineBreak);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", path);
        model.put("type", type);
        model.put("optional", optional);
        model.put("description", description);
        return model;
    }

    private List<String> resolveConstraints(FieldDescriptor descriptor) {
        return (List)descriptor.getAttributes().get("constraints");
    }

    private String resolveOptional(FieldDescriptor descriptor, String forcedLineBreak) {
        List optionalMessages = (List)descriptor.getAttributes().get("optionals");
        return "" + StringUtils.join((Iterable)optionalMessages, (String)forcedLineBreak);
    }

    private String toString(Object value) {
        if (value != null) {
            return StringUtils.trimToEmpty((String)value.toString());
        }
        return "";
    }

    private String joinAndFormat(String description, List<String> constraints, String forcedLineBreak) {
        StringBuilder res = new StringBuilder(description);
        if (!description.isEmpty() && !description.endsWith(".")) {
            res.append('.');
        }
        StringBuilder constr = this.formatConstraints(constraints, forcedLineBreak);
        if (res.length() > 0 && constr.length() > 0) {
            res.append("\n\n");
        }
        res.append(constr.toString());
        return res.toString();
    }

    private StringBuilder formatConstraints(List<String> constraints, String forcedLineBreak) {
        StringBuilder res = new StringBuilder();
        for (String constraint : constraints) {
            if (constraint.trim().isEmpty()) continue;
            if (res.length() > 0) {
                res.append(forcedLineBreak);
            }
            res.append(constraint.trim());
            if (constraint.endsWith(".")) continue;
            res.append('.');
        }
        return res;
    }
}

