/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.util;

import capital.scalable.restdocs.util.FieldUtil;
import java.lang.reflect.Field;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class TypeUtil {
    private TypeUtil() {
    }

    public static String determineTypeName(Class<?> type) {
        switch (ClassUtils.primitiveToWrapper(type).getCanonicalName()) {
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Long": 
            case "java.lang.Integer": 
            case "java.math.BigInteger": {
                return "Integer";
            }
            case "java.lang.Float": 
            case "java.lang.Double": 
            case "java.math.BigDecimal": {
                return "Decimal";
            }
            case "java.lang.Character": {
                return "String";
            }
            case "java.lang.Boolean": {
                return "Boolean";
            }
        }
        return type.getSimpleName();
    }

    public static boolean isPrimitive(Class<?> javaBaseClass, String javaFieldName) {
        Field field = ReflectionUtils.findField(javaBaseClass, (String)javaFieldName);
        if (field == null && FieldUtil.isGetter(javaFieldName)) {
            field = ReflectionUtils.findField(javaBaseClass, (String)FieldUtil.fromGetter(javaFieldName));
        }
        return field != null ? field.getType().isPrimitive() : false;
    }
}

