/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.InternalFieldInfo;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.util.FieldUtil;
import capital.scalable.restdocs.util.FormatUtil;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.snippet.Attributes;

class FieldDocumentationVisitorContext {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentationVisitorContext.class);
    private final List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
    private final JavadocReader javadocReader;
    private final ConstraintReader constraintReader;
    private final DeserializationConfig deserializationConfig;

    public FieldDocumentationVisitorContext(JavadocReader javadocReader, ConstraintReader constraintReader, DeserializationConfig deserializationConfig) {
        this.javadocReader = javadocReader;
        this.constraintReader = constraintReader;
        this.deserializationConfig = deserializationConfig;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public void addField(InternalFieldInfo info, String jsonType) {
        String javaFieldTypeName;
        String jsonFieldPath = info.getJsonFieldPath();
        if (this.isPresent(jsonFieldPath, javaFieldTypeName = info.getJavaFieldType().getRawClass().getSimpleName())) {
            return;
        }
        Class<?> javaBaseClass = info.getJavaBaseClass();
        String javaFieldName = info.getJavaFieldName();
        String comment = this.resolveComment(javaBaseClass, javaFieldName);
        comment = FormatUtil.join("<br>", comment, this.resolveSeeTag(javaBaseClass, javaFieldName));
        FieldDescriptor fieldDescriptor = (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)jsonFieldPath).type((Object)jsonType).description((Object)comment);
        Attributes.Attribute constraints = this.constraintAttribute(javaBaseClass, javaFieldName);
        Attributes.Attribute optionals = this.optionalAttribute(javaBaseClass, javaFieldName);
        Attributes.Attribute deprecated = this.deprecatedAttribute(javaBaseClass, javaFieldName);
        fieldDescriptor.attributes(new Attributes.Attribute[]{constraints, optionals, deprecated});
        this.fields.add(fieldDescriptor);
        log.debug("({}) {} added", (Object)jsonFieldPath, (Object)javaFieldTypeName);
    }

    private boolean isPresent(String jsonFieldPath, String javaFieldTypeName) {
        log.trace(" = WAS ADDED? {}", (Object)jsonFieldPath);
        for (FieldDescriptor descriptor : this.fields) {
            if (descriptor.getPath().equals(jsonFieldPath)) {
                log.trace("   = YES {}", (Object)descriptor.getPath());
                log.debug("({}) {} NOT added", (Object)jsonFieldPath, (Object)javaFieldTypeName);
                return true;
            }
            log.trace("   = NO {}", (Object)descriptor.getPath());
        }
        return false;
    }

    private Attributes.Attribute constraintAttribute(Class<?> javaBaseClass, String javaFieldName) {
        return new Attributes.Attribute("constraints", this.resolveConstraintDescriptions(javaBaseClass, javaFieldName));
    }

    private Attributes.Attribute optionalAttribute(Class<?> javaBaseClass, String javaFieldName) {
        return new Attributes.Attribute("optionals", this.resolveOptionalMessages(javaBaseClass, javaFieldName));
    }

    private Attributes.Attribute deprecatedAttribute(Class<?> javaBaseClass, String javaFieldName) {
        return new Attributes.Attribute("deprecated", (Object)this.resolveDeprecatedMessage(javaBaseClass, javaFieldName));
    }

    private List<String> resolveOptionalMessages(Class<?> javaBaseClass, String javaFieldName) {
        ArrayList<String> optionalMessages = new ArrayList<String>();
        if (TypeUtil.isPrimitive(javaBaseClass, javaFieldName)) {
            boolean failOnNullForPrimitives = this.deserializationConfig.hasDeserializationFeatures(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES.getMask());
            optionalMessages.add("" + !failOnNullForPrimitives);
            return optionalMessages;
        }
        optionalMessages.addAll(this.constraintReader.getOptionalMessages(javaBaseClass, javaFieldName));
        if (optionalMessages.isEmpty() && FieldUtil.isGetter(javaFieldName)) {
            optionalMessages.addAll(this.constraintReader.getOptionalMessages(javaBaseClass, FieldUtil.fromGetter(javaFieldName)));
        }
        if (!optionalMessages.contains("false") && !optionalMessages.contains("true")) {
            optionalMessages.add(0, "true");
        }
        return optionalMessages;
    }

    private List<String> resolveConstraintDescriptions(Class<?> javaBaseClass, String javaFieldName) {
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.addAll(this.constraintReader.getConstraintMessages(javaBaseClass, javaFieldName));
        if (descriptions.isEmpty() && FieldUtil.isGetter(javaFieldName)) {
            descriptions.addAll(this.constraintReader.getConstraintMessages(javaBaseClass, FieldUtil.fromGetter(javaFieldName)));
        }
        return descriptions;
    }

    private String resolveDeprecatedMessage(Class<?> javaBaseClass, String javaFieldName) {
        boolean isDeprecated = TypeUtil.resolveAnnotation(javaBaseClass, javaFieldName, Deprecated.class) != null;
        String comment = this.resolveTag(javaBaseClass, javaFieldName, "deprecated");
        if (isDeprecated || StringUtils.isNotBlank((CharSequence)comment)) {
            return StringUtils.trimToEmpty((String)comment);
        }
        return null;
    }

    private String resolveSeeTag(Class<?> javaBaseClass, String javaFieldName) {
        String comment = this.resolveTag(javaBaseClass, javaFieldName, "see");
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            return FormatUtil.addDot(SnippetTranslationResolver.translate("tags-see", comment));
        }
        return "";
    }

    private String resolveComment(Class<?> javaBaseClass, String javaFieldOrMethodName) {
        String comment = this.javadocReader.resolveMethodComment(javaBaseClass, javaFieldOrMethodName);
        if (StringUtils.isBlank((CharSequence)comment)) {
            comment = this.javadocReader.resolveFieldComment(javaBaseClass, javaFieldOrMethodName);
        }
        if (StringUtils.isBlank((CharSequence)comment) && FieldUtil.isGetter(javaFieldOrMethodName)) {
            comment = this.javadocReader.resolveFieldComment(javaBaseClass, FieldUtil.fromGetter(javaFieldOrMethodName));
        }
        return comment;
    }

    private String resolveTag(Class<?> javaBaseClass, String javaFieldOrMethodName, String tagName) {
        String comment = this.javadocReader.resolveMethodTag(javaBaseClass, javaFieldOrMethodName, tagName);
        if (StringUtils.isBlank((CharSequence)comment)) {
            comment = this.javadocReader.resolveFieldTag(javaBaseClass, javaFieldOrMethodName, tagName);
        }
        if (StringUtils.isBlank((CharSequence)comment) && FieldUtil.isGetter(javaFieldOrMethodName)) {
            comment = this.javadocReader.resolveFieldTag(javaBaseClass, FieldUtil.fromGetter(javaFieldOrMethodName), tagName);
        }
        return comment;
    }
}

