/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.request;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.section.SectionSupport;
import capital.scalable.restdocs.snippet.StandardTableSnippet;
import capital.scalable.restdocs.util.FieldDescriptorUtil;
import capital.scalable.restdocs.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.snippet.Attributes;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;

abstract class AbstractParameterSnippet<A extends Annotation>
extends StandardTableSnippet
implements SectionSupport {
    protected AbstractParameterSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    protected List<FieldDescriptor> createFieldDescriptors(Operation operation, HandlerMethod handlerMethod) {
        JavadocReader javadocReader = OperationAttributeHelper.getJavadocReader(operation);
        ConstraintReader constraintReader = OperationAttributeHelper.getConstraintReader(operation);
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        for (MethodParameter param : handlerMethod.getMethodParameters()) {
            A annot = this.getAnnotation(param);
            if (annot == null) continue;
            this.addFieldDescriptor(handlerMethod, javadocReader, constraintReader, fieldDescriptors, param, annot);
        }
        if (this.shouldFailOnUndocumentedParams()) {
            FieldDescriptorUtil.assertAllDocumented(fieldDescriptors, SnippetTranslationResolver.translate(this.getHeaderKey(), new Object[0]).toLowerCase());
        }
        return fieldDescriptors;
    }

    private void addFieldDescriptor(HandlerMethod handlerMethod, JavadocReader javadocReader, ConstraintReader constraintReader, List<FieldDescriptor> fieldDescriptors, MethodParameter param, A annot) {
        String javaParameterName = param.getParameterName();
        String pathName = this.getPath(annot);
        String parameterName = StringUtils.hasLength((String)pathName) ? pathName : javaParameterName;
        String parameterTypeName = TypeUtil.determineTypeName(param.getParameterType());
        String description = javadocReader.resolveMethodParameterComment(handlerMethod.getBeanType(), handlerMethod.getMethod().getName(), javaParameterName);
        FieldDescriptor descriptor = (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)parameterName).type((Object)parameterTypeName).description((Object)description);
        Attributes.Attribute constraints = this.constraintAttribute(param, constraintReader);
        Attributes.Attribute optionals = this.optionalsAttribute(param, annot);
        Attributes.Attribute deprecated = this.deprecatedAttribute(param, annot, javadocReader);
        Attributes.Attribute defaultValue = this.defaultValueAttribute(annot);
        if (defaultValue == null) {
            descriptor.attributes(new Attributes.Attribute[]{constraints, optionals, deprecated});
        } else {
            descriptor.attributes(new Attributes.Attribute[]{constraints, optionals, deprecated, defaultValue});
        }
        fieldDescriptors.add(descriptor);
    }

    protected abstract String getDefaultValue(A var1);

    protected boolean isCustomDefaultValue(String defaultValue) {
        return defaultValue != null && !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue);
    }

    protected Attributes.Attribute constraintAttribute(MethodParameter param, ConstraintReader constraintReader) {
        return new Attributes.Attribute("constraints", constraintReader.getConstraintMessages(param));
    }

    protected Attributes.Attribute optionalsAttribute(MethodParameter param, A annot) {
        return new Attributes.Attribute("optionals", Collections.singletonList(!this.isRequired(param, annot)));
    }

    protected Attributes.Attribute deprecatedAttribute(MethodParameter param, A annot, JavadocReader javadocReader) {
        return new Attributes.Attribute("deprecated", (Object)(param.getParameterAnnotation(Deprecated.class) != null ? "" : null));
    }

    protected Attributes.Attribute defaultValueAttribute(A annot) {
        String defaultValue = this.getDefaultValue(annot);
        return this.isCustomDefaultValue(defaultValue) ? new Attributes.Attribute("default-value", (Object)defaultValue) : null;
    }

    protected abstract boolean isRequired(MethodParameter var1, A var2);

    protected abstract String getPath(A var1);

    abstract A getAnnotation(MethodParameter var1);

    protected abstract boolean shouldFailOnUndocumentedParams();

    @Override
    public String getFileName() {
        return this.getSnippetName();
    }

    @Override
    public boolean hasContent(Operation operation) {
        for (MethodParameter param : OperationAttributeHelper.getHandlerMethod(operation).getMethodParameters()) {
            A annot = this.getAnnotation(param);
            if (annot == null) continue;
            return true;
        }
        return false;
    }
}

