/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.jackson.FieldDocumentationVisitorContext;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorWrapper;
import capital.scalable.restdocs.jackson.InternalFieldInfo;
import capital.scalable.restdocs.jackson.RestdocsNotExpanded;
import capital.scalable.restdocs.jackson.TypeRegistry;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class FieldDocumentationObjectVisitor
extends JsonObjectFormatVisitor.Base {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentationObjectVisitor.class);
    private static final Set<String> SKIPPED_FIELDS = new HashSet<String>(Arrays.asList("_links", "_embedded"));
    private static final Set<String> SKIPPED_CLASSES = new HashSet<String>(Arrays.asList("org.springframework.hateoas.Link", "org.springframework.hateoas.core.EmbeddedWrapper"));
    private final FieldDocumentationVisitorContext context;
    private final String path;
    private final TypeRegistry typeRegistry;
    private final TypeFactory typeFactory;

    public FieldDocumentationObjectVisitor(SerializerProvider provider, FieldDocumentationVisitorContext context, String path, TypeRegistry typeRegistry, TypeFactory typeFactory) {
        super(provider);
        this.context = context;
        this.path = path;
        this.typeRegistry = typeRegistry;
        this.typeFactory = typeFactory;
    }

    public void property(BeanProperty prop) throws JsonMappingException {
        this.property(prop, true);
    }

    public void optionalProperty(BeanProperty prop) throws JsonMappingException {
        this.property(prop, false);
    }

    public void property(BeanProperty prop, boolean required) throws JsonMappingException {
        String jsonName = prop.getName();
        String fieldName = prop.getMember().getName();
        JavaType baseType = prop.getType();
        Assert.notNull((Object)baseType, (String)("Missing type for property '" + jsonName + "', field '" + fieldName + "'"));
        for (JavaType javaType : TypeUtil.resolveAllTypes(baseType, this.typeFactory)) {
            JsonSerializer ser = this.getProvider().findValueSerializer(javaType, prop);
            if (ser == null) {
                return;
            }
            if (this.shouldSkip(prop)) {
                return;
            }
            this.visitType(prop, jsonName, fieldName, javaType, ser, required);
        }
    }

    private void visitType(BeanProperty prop, String jsonName, String fieldName, JavaType fieldType, JsonSerializer<?> ser, boolean required) throws JsonMappingException {
        String fieldPath = this.path + (this.path.isEmpty() ? "" : ".") + jsonName;
        log.debug("({}) {}", (Object)fieldPath, (Object)fieldType.getRawClass().getSimpleName());
        Class javaBaseClass = prop.getMember().getDeclaringClass();
        boolean shouldExpand = this.shouldExpand(prop);
        InternalFieldInfo fieldInfo = new InternalFieldInfo(javaBaseClass, fieldName, fieldType, fieldPath, shouldExpand, required);
        FieldDocumentationVisitorWrapper visitor = new FieldDocumentationVisitorWrapper(this.getProvider(), this.context, fieldPath, fieldInfo, this.typeRegistry, this.typeFactory);
        ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, fieldType);
    }

    private boolean shouldExpand(BeanProperty prop) {
        return prop.getMember().getAnnotation(RestdocsNotExpanded.class) == null;
    }

    private boolean shouldSkip(BeanProperty prop) {
        Class rawClass = prop.getType().getContentType() != null ? prop.getType().getContentType().getRawClass() : prop.getType().getRawClass();
        return SKIPPED_FIELDS.contains(prop.getName()) || SKIPPED_CLASSES.contains(rawClass.getCanonicalName());
    }
}

