/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.payload;

import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.payload.AbstractJacksonFieldSnippet;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.method.HandlerMethod;

public class JacksonResponseFieldSnippet
extends AbstractJacksonFieldSnippet {
    public static final String SPRING_DATA_PAGE_CLASS = "org.springframework.data.domain.Page";
    public static final String REACTOR_MONO_CLASS = "reactor.core.publisher.Mono";
    public static final String REACTOR_FLUX_CLASS = "reactor.core.publisher.Flux";
    private final Type responseBodyType;
    private final boolean failOnUndocumentedFields;

    public JacksonResponseFieldSnippet() {
        this(null, false);
    }

    public JacksonResponseFieldSnippet(Type responseBodyType, boolean failOnUndocumentedFields) {
        super("auto-response-fields", null);
        this.responseBodyType = responseBodyType;
        this.failOnUndocumentedFields = failOnUndocumentedFields;
    }

    public JacksonResponseFieldSnippet responseBodyAsType(Type responseBodyType) {
        return new JacksonResponseFieldSnippet(responseBodyType, this.failOnUndocumentedFields);
    }

    public JacksonResponseFieldSnippet failOnUndocumentedFields(boolean failOnUndocumentedFields) {
        return new JacksonResponseFieldSnippet(this.responseBodyType, failOnUndocumentedFields);
    }

    @Override
    protected Type getType(HandlerMethod method) {
        if (this.responseBodyType != null) {
            return this.responseBodyType;
        }
        Class returnType = method.getReturnType().getParameterType();
        if (returnType == ResponseEntity.class) {
            return this.firstGenericType(method.getReturnType());
        }
        if (returnType == HttpEntity.class) {
            return this.firstGenericType(method.getReturnType());
        }
        if (SPRING_DATA_PAGE_CLASS.equals(returnType.getCanonicalName())) {
            return this.firstGenericType(method.getReturnType());
        }
        if (this.isCollection(returnType)) {
            return () -> this.firstGenericType(method.getReturnType());
        }
        if ("void".equals(returnType.getName())) {
            return null;
        }
        if (REACTOR_MONO_CLASS.equals(returnType.getCanonicalName())) {
            return this.firstGenericType(method.getReturnType());
        }
        if (REACTOR_FLUX_CLASS.equals(returnType.getCanonicalName())) {
            return () -> this.firstGenericType(method.getReturnType());
        }
        return returnType;
    }

    @Override
    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod, FieldDescriptors fieldDescriptors) {
        model.put("isPageResponse", this.isPageResponse(handlerMethod));
        if (fieldDescriptors.getNoContentMessageKey() != null) {
            model.put("no-response-body", SnippetTranslationResolver.translate(fieldDescriptors.getNoContentMessageKey(), new Object[0]));
        }
    }

    private boolean isPageResponse(HandlerMethod handlerMethod) {
        return SPRING_DATA_PAGE_CLASS.equals(handlerMethod.getReturnType().getParameterType().getCanonicalName());
    }

    @Override
    public String getHeaderKey() {
        return "response-fields";
    }

    @Override
    protected boolean shouldFailOnUndocumentedFields() {
        return this.failOnUndocumentedFields;
    }

    @Override
    protected String[] getTranslationKeys() {
        return new String[]{"th-path", "th-type", "th-optional", "th-description", "pagination-response-adoc", "pagination-response-md", "no-response-body"};
    }
}

