/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.request;

import capital.scalable.restdocs.request.AbstractParameterSnippet;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.PathVariable;

public class PathParametersSnippet
extends AbstractParameterSnippet<PathVariable> {
    private final boolean failOnUndocumentedParams;

    public PathParametersSnippet() {
        this(false);
    }

    public PathParametersSnippet(boolean failOnUndocumentedParams) {
        super("auto-path-parameters", null);
        this.failOnUndocumentedParams = failOnUndocumentedParams;
    }

    public PathParametersSnippet failOnUndocumentedParams(boolean failOnUndocumentedParams) {
        return new PathParametersSnippet(failOnUndocumentedParams);
    }

    @Override
    protected boolean isRequired(MethodParameter param, PathVariable annot) {
        return param.getParameterType().isPrimitive() || !param.isOptional() && annot.required();
    }

    @Override
    protected String getPath(PathVariable annot) {
        return annot.value();
    }

    @Override
    protected PathVariable getAnnotation(MethodParameter param) {
        return (PathVariable)param.getParameterAnnotation(PathVariable.class);
    }

    @Override
    public String getHeaderKey() {
        return "path-parameters";
    }

    @Override
    protected boolean shouldFailOnUndocumentedParams() {
        return this.failOnUndocumentedParams;
    }

    @Override
    protected String getDefaultValue(PathVariable annotation) {
        return null;
    }

    @Override
    protected String[] getTranslationKeys() {
        return new String[]{"th-parameter", "th-type", "th-optional", "th-description", "no-params"};
    }
}

