/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorWrapper;
import capital.scalable.restdocs.jackson.TypeMapping;
import capital.scalable.restdocs.jackson.TypeRegistry;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.payload.FieldDescriptor;

public class FieldDocumentationGenerator {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentationGenerator.class);
    private static final Set<String> RESOURCES_TYPES = new HashSet<String>(Arrays.asList("org.springframework.hateoas.Resources", "org.springframework.hateoas.CollectionModel"));
    private final ObjectWriter writer;
    private final DeserializationConfig deserializationConfig;
    private final JavadocReader javadocReader;
    private final ConstraintReader constraintReader;
    private final TypeMapping typeMapping;
    private final SnippetTranslationResolver translationResolver;

    public FieldDocumentationGenerator(ObjectWriter writer, DeserializationConfig deserializationConfig, JavadocReader javadocReader, ConstraintReader constraintReader, TypeMapping typeMapping, SnippetTranslationResolver translationResolver) {
        this.writer = writer;
        this.deserializationConfig = deserializationConfig;
        this.javadocReader = javadocReader;
        this.constraintReader = constraintReader;
        this.typeMapping = typeMapping;
        this.translationResolver = translationResolver;
    }

    public FieldDescriptors generateDocumentation(Type baseType, TypeFactory typeFactory) throws JsonMappingException {
        JavaType javaBaseType = typeFactory.constructType(baseType);
        List<JavaType> types = TypeUtil.resolveAllTypes(javaBaseType, typeFactory, this.typeMapping);
        FieldDescriptors result = new FieldDescriptors();
        FieldDocumentationVisitorWrapper visitorWrapper = FieldDocumentationVisitorWrapper.create(this.javadocReader, this.constraintReader, this.deserializationConfig, new TypeRegistry(this.typeMapping, types), typeFactory, this.translationResolver);
        for (JavaType type : types) {
            log.debug("(TOP) {}", (Object)type.getRawClass().getSimpleName());
            if (RESOURCES_TYPES.contains(type.getRawClass().getCanonicalName())) {
                result.setNoContentMessageKey("body-as-embedded-resources");
                continue;
            }
            this.writer.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)visitorWrapper);
        }
        for (FieldDescriptor descriptor : visitorWrapper.getFields()) {
            result.putIfAbsent(descriptor.getPath(), descriptor);
        }
        return result;
    }
}

