/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.payload;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.payload.AbstractJacksonFieldSnippet;
import capital.scalable.restdocs.util.HandlerMethodUtil;
import capital.scalable.restdocs.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;

public class JacksonModelAttributeSnippet
extends AbstractJacksonFieldSnippet {
    private final boolean failOnUndocumentedFields;
    private final Collection<HandlerMethodArgumentResolver> handlerMethodArgumentResolvers;

    public JacksonModelAttributeSnippet() {
        this(null, false);
    }

    public JacksonModelAttributeSnippet(Collection<HandlerMethodArgumentResolver> handlerMethodArgumentResolvers, boolean failOnUndocumentedFields) {
        super("auto-modelattribute", null);
        this.failOnUndocumentedFields = failOnUndocumentedFields;
        this.handlerMethodArgumentResolvers = handlerMethodArgumentResolvers;
    }

    @Override
    protected Type getType(HandlerMethod method) {
        for (MethodParameter param : method.getMethodParameters()) {
            if (!this.isModelAttribute(param) && !this.hasNoHandlerMethodArgumentResolver(param)) continue;
            return this.getType(param);
        }
        return null;
    }

    private boolean isModelAttribute(MethodParameter param) {
        return param.getParameterAnnotation(ModelAttribute.class) != null;
    }

    private boolean hasNoHandlerMethodArgumentResolver(MethodParameter param) {
        return !BeanUtils.isSimpleProperty((Class)param.getParameterType()) && this.handlerMethodArgumentResolvers != null && this.handlerMethodArgumentResolvers.stream().noneMatch(obj -> obj.supportsParameter(param));
    }

    private Type getType(MethodParameter param) {
        if (this.isCollection(param.getParameterType())) {
            return () -> TypeUtil.firstGenericType(param);
        }
        return param.getParameterType();
    }

    protected boolean isRequestMethodGet(HandlerMethod method) {
        RequestMapping requestMapping = (RequestMapping)method.getMethodAnnotation(RequestMapping.class);
        return requestMapping == null || requestMapping.method() == null || Arrays.stream(requestMapping.method()).anyMatch(requestMethod -> requestMethod == RequestMethod.GET);
    }

    @Override
    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod, FieldDescriptors fieldDescriptors, SnippetTranslationResolver translationResolver) {
        boolean isPageRequest = HandlerMethodUtil.isPageRequest(handlerMethod);
        model.put("isPageRequest", isPageRequest);
        if (isPageRequest) {
            model.put("noContent", false);
        }
    }

    @Override
    protected boolean shouldFailOnUndocumentedFields() {
        return this.failOnUndocumentedFields;
    }

    @Override
    public String getHeaderKey(Operation operation) {
        HandlerMethod method = OperationAttributeHelper.getHandlerMethod(operation);
        if (method != null && this.isRequestMethodGet(method)) {
            return "request-parameters";
        }
        return "request-fields";
    }

    @Override
    protected String[] getTranslationKeys() {
        return new String[]{"th-parameter", "th-type", "th-optional", "th-description", "pagination-request-adoc", "pagination-request-md", "no-params"};
    }
}

