/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.payload;

import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.payload.AbstractJacksonFieldSnippet;
import capital.scalable.restdocs.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpEntity;
import org.springframework.restdocs.operation.Operation;
import org.springframework.web.method.HandlerMethod;

public class JacksonResponseFieldSnippet
extends AbstractJacksonFieldSnippet {
    private static final Set<String> SPRING_PAGE_CLASSES = new HashSet<String>(Arrays.asList("org.springframework.data.domain.Page", "org.springframework.hateoas.PagedModel"));
    public static final Set<String> SPRING_HATEOAS_CLASSES = new HashSet<String>(Arrays.asList("org.springframework.hateoas.Resource", "org.springframework.hateoas.EntityModel"));
    public static final String REACTOR_MONO_CLASS = "reactor.core.publisher.Mono";
    public static final String REACTOR_FLUX_CLASS = "reactor.core.publisher.Flux";
    private final Type responseBodyType;
    private final boolean failOnUndocumentedFields;

    public JacksonResponseFieldSnippet() {
        this(null, false);
    }

    public JacksonResponseFieldSnippet(Type responseBodyType, boolean failOnUndocumentedFields) {
        super("auto-response-fields", null);
        this.responseBodyType = responseBodyType;
        this.failOnUndocumentedFields = failOnUndocumentedFields;
    }

    public JacksonResponseFieldSnippet responseBodyAsType(Type responseBodyType) {
        return new JacksonResponseFieldSnippet(responseBodyType, this.failOnUndocumentedFields);
    }

    public JacksonResponseFieldSnippet failOnUndocumentedFields(boolean failOnUndocumentedFields) {
        return new JacksonResponseFieldSnippet(this.responseBodyType, failOnUndocumentedFields);
    }

    @Override
    protected Type getType(HandlerMethod method) {
        if (this.responseBodyType != null) {
            return this.responseBodyType;
        }
        Class returnType = method.getReturnType().getParameterType();
        if (HttpEntity.class.isAssignableFrom(returnType)) {
            return TypeUtil.firstGenericType(method.getReturnType());
        }
        if (SPRING_PAGE_CLASSES.contains(returnType.getCanonicalName())) {
            return TypeUtil.firstGenericType(method.getReturnType());
        }
        if (SPRING_HATEOAS_CLASSES.contains(returnType.getCanonicalName())) {
            return TypeUtil.firstGenericType(method.getReturnType());
        }
        if (this.isCollection(returnType)) {
            return () -> TypeUtil.firstGenericType(method.getReturnType());
        }
        if ("void".equals(returnType.getName())) {
            return null;
        }
        if (REACTOR_MONO_CLASS.equals(returnType.getCanonicalName())) {
            Type type = TypeUtil.firstGenericType(method.getReturnType());
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return type;
        }
        if (REACTOR_FLUX_CLASS.equals(returnType.getCanonicalName())) {
            return () -> TypeUtil.firstGenericType(method.getReturnType());
        }
        if (method.getReturnType().getGenericParameterType() instanceof TypeVariable) {
            return TypeUtil.firstGenericType(method.getReturnType());
        }
        return returnType;
    }

    @Override
    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod, FieldDescriptors fieldDescriptors, SnippetTranslationResolver translationResolver) {
        model.put("isPageResponse", this.isPageResponse(handlerMethod));
        if (fieldDescriptors.getNoContentMessageKey() != null) {
            model.put("no-response-body", translationResolver.translate(fieldDescriptors.getNoContentMessageKey(), new Object[0]));
        }
    }

    private boolean isPageResponse(HandlerMethod handlerMethod) {
        return SPRING_PAGE_CLASSES.contains(handlerMethod.getReturnType().getParameterType().getCanonicalName());
    }

    @Override
    public String getHeaderKey(Operation operation) {
        return "response-fields";
    }

    @Override
    protected boolean shouldFailOnUndocumentedFields() {
        return this.failOnUndocumentedFields;
    }

    @Override
    protected String[] getTranslationKeys() {
        return new String[]{"th-path", "th-type", "th-optional", "th-description", "pagination-response-adoc", "pagination-response-md", "no-response-body"};
    }
}

