/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.ConstraintAndGroupDescriptionResolver;
import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.constraints.HumanReadableConstraintResolver;
import capital.scalable.restdocs.constraints.MethodParameterConstraintResolver;
import capital.scalable.restdocs.constraints.MethodParameterValidatorConstraintResolver;
import capital.scalable.restdocs.constraints.NoOpMethodParameterConstraintResolver;
import capital.scalable.restdocs.constraints.SkippableConstraintResolver;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.util.FormatUtil;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;
import org.springframework.restdocs.constraints.ConstraintDescriptions;
import org.springframework.restdocs.constraints.ConstraintResolver;
import org.springframework.util.ReflectionUtils;

public class ConstraintReaderImpl
implements ConstraintReader {
    private static final Logger log = LoggerFactory.getLogger(ConstraintReaderImpl.class);
    private final ConstraintAndGroupDescriptionResolver constraintAndGroupDescriptionResolver;
    private final SkippableConstraintResolver skippableConstraintResolver;
    private final MethodParameterConstraintResolver constraintResolver;
    private final ObjectMapper objectMapper;
    private final SnippetTranslationResolver translationResolver;

    private ConstraintReaderImpl(MethodParameterConstraintResolver actualResolver, ObjectMapper objectMapper, SnippetTranslationResolver translationResolver, ConstraintDescriptionResolver constraintDescriptionResolver) {
        this.translationResolver = translationResolver;
        this.constraintAndGroupDescriptionResolver = new ConstraintAndGroupDescriptionResolver(constraintDescriptionResolver, translationResolver);
        this.skippableConstraintResolver = new SkippableConstraintResolver(actualResolver, this.constraintAndGroupDescriptionResolver);
        this.constraintResolver = new HumanReadableConstraintResolver(this.skippableConstraintResolver);
        this.objectMapper = objectMapper;
    }

    public static ConstraintReaderImpl create(ObjectMapper objectMapper, SnippetTranslationResolver translationResolver, ConstraintDescriptionResolver constraintDescriptionResolver) {
        return MethodParameterValidatorConstraintResolver.CONSTRAINT_CLASS != null ? ConstraintReaderImpl.createWithValidation(objectMapper, translationResolver, constraintDescriptionResolver) : ConstraintReaderImpl.createWithoutValidation(objectMapper, translationResolver, constraintDescriptionResolver);
    }

    static ConstraintReaderImpl createWithoutValidation(ObjectMapper objectMapper, SnippetTranslationResolver translationResolver, ConstraintDescriptionResolver constraintDescriptionResolver) {
        return new ConstraintReaderImpl(new NoOpMethodParameterConstraintResolver(), objectMapper, translationResolver, constraintDescriptionResolver);
    }

    static ConstraintReaderImpl createWithValidation(ObjectMapper objectMapper, SnippetTranslationResolver translationResolver, ConstraintDescriptionResolver constraintDescriptionResolver) {
        return new ConstraintReaderImpl(new MethodParameterValidatorConstraintResolver(), objectMapper, translationResolver, constraintDescriptionResolver);
    }

    @Override
    public List<String> getOptionalMessages(Class<?> javaBaseClass, String javaFieldName) {
        return this.skippableConstraintResolver.getOptionalMessages(javaFieldName, javaBaseClass);
    }

    @Override
    public String getTypeSpecifier(Class<?> javaBaseClass) {
        String message = this.constraintAndGroupDescriptionResolver.resolveDescription(new Constraint(javaBaseClass.getCanonicalName(), Collections.emptyMap()));
        if (message.equals(javaBaseClass.getCanonicalName())) {
            return "";
        }
        return message;
    }

    @Override
    public List<String> getConstraintMessages(Class<?> javaBaseClass, String javaFieldName) {
        ConstraintDescriptions constraints = new ConstraintDescriptions(javaBaseClass, (ConstraintResolver)this.constraintResolver, (ConstraintDescriptionResolver)this.constraintAndGroupDescriptionResolver);
        ArrayList<String> constraintMessages = new ArrayList<String>();
        constraintMessages.addAll(constraints.descriptionsForProperty(javaFieldName));
        constraintMessages.addAll(this.getEnumConstraintMessage(javaBaseClass, javaFieldName));
        return constraintMessages;
    }

    @Override
    public List<String> getConstraintMessages(MethodParameter param) {
        List<Constraint> constraints = this.constraintResolver.resolveForParameter(param);
        ArrayList<String> constraintMessages = new ArrayList<String>();
        for (Constraint constraint : constraints) {
            constraintMessages.add(this.constraintAndGroupDescriptionResolver.resolveDescription(constraint));
        }
        constraintMessages.addAll(this.getEnumConstraintMessage(param));
        Collections.sort(constraintMessages);
        return constraintMessages;
    }

    private List<String> getEnumConstraintMessage(Class<?> javaBaseClass, String javaFieldName) {
        Field field = ReflectionUtils.findField(javaBaseClass, (String)javaFieldName);
        if (field == null) {
            return Collections.emptyList();
        }
        if (field.getType().isEnum()) {
            return this.getEnumConstraintMessage(field.getType());
        }
        return this.getEnumConstraintMessage(TypeUtil.firstGenericType(field.getGenericType(), javaBaseClass));
    }

    private List<String> getEnumConstraintMessage(MethodParameter param) {
        if (param.getParameterType().isEnum()) {
            return this.getEnumConstraintMessage(param.getParameterType());
        }
        return this.getEnumConstraintMessage(TypeUtil.firstGenericType(param));
    }

    private List<String> getEnumConstraintMessage(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return this.getEnumConstraintMessage(clazz);
        }
        return Collections.emptyList();
    }

    private List<String> getEnumConstraintMessage(Class<?> rawClass) {
        if (!rawClass.isEnum()) {
            return Collections.emptyList();
        }
        Class<?> enumClass = rawClass;
        ArrayList<String> serializedEnumValues = new ArrayList<String>();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            try {
                String jsonValue = this.objectMapper.writeValueAsString((Object)e);
                jsonValue = StringUtils.removeStart((String)jsonValue, (String)"\"");
                jsonValue = StringUtils.removeEnd((String)jsonValue, (String)"\"");
                serializedEnumValues.add(jsonValue);
            }
            catch (JsonProcessingException ex) {
                log.error("Failed to convert enum {}", (Object)e, (Object)ex);
            }
        }
        String value = FormatUtil.collectionToString(serializedEnumValues);
        String enumName = enumClass.getCanonicalName();
        String message = this.constraintAndGroupDescriptionResolver.resolveDescription(new Constraint(enumName, Collections.singletonMap("value", value)));
        if (StringUtils.isBlank((CharSequence)message) || message.equals(enumName)) {
            message = this.translationResolver.translate("constraints-enum", value);
        }
        return Collections.singletonList(message);
    }
}

