/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.ConstraintAndGroupDescriptionResolver;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;
import org.springframework.restdocs.constraints.ResourceBundleConstraintDescriptionResolver;
import org.springframework.util.PropertyPlaceholderHelper;

public class DynamicResourceBundleConstraintDescriptionResolver
implements ConstraintDescriptionResolver {
    private static final Logger log = LoggerFactory.getLogger(ConstraintAndGroupDescriptionResolver.class);
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
    private final ResourceBundle defaultDescriptions = DynamicResourceBundleConstraintDescriptionResolver.getBundle("DefaultConstraintDescriptions");
    private final ResourceBundle userDescriptions;

    public DynamicResourceBundleConstraintDescriptionResolver() {
        this(DynamicResourceBundleConstraintDescriptionResolver.getBundle("ConstraintDescriptions"));
    }

    public DynamicResourceBundleConstraintDescriptionResolver(ResourceBundle resourceBundle) {
        this.userDescriptions = resourceBundle;
    }

    private static ResourceBundle getBundle(String name) {
        try {
            return ResourceBundle.getBundle(ResourceBundleConstraintDescriptionResolver.class.getPackage().getName() + "." + name, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public String resolveDescription(Constraint constraint) {
        String message = (String)constraint.getConfiguration().get("message");
        if (StringUtils.isNotBlank((CharSequence)message) && !message.startsWith("{")) {
            return this.propertyPlaceholderHelper.replacePlaceholders(message, (PropertyPlaceholderHelper.PlaceholderResolver)new ConstraintPlaceholderResolver(constraint));
        }
        try {
            String key = constraint.getName() + ".description";
            return this.propertyPlaceholderHelper.replacePlaceholders(this.getDescription(key), (PropertyPlaceholderHelper.PlaceholderResolver)new ConstraintPlaceholderResolver(constraint));
        }
        catch (MissingResourceException e) {
            log.debug("No description found for constraint {}: {}.", (Object)constraint.getName(), (Object)e.getMessage());
            return "";
        }
    }

    private String getDescription(String key) {
        try {
            if (this.userDescriptions != null) {
                return this.userDescriptions.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.defaultDescriptions.getString(key);
    }

    private static final class ConstraintPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Constraint constraint;

        private ConstraintPlaceholderResolver(Constraint constraint) {
            this.constraint = constraint;
        }

        public String resolvePlaceholder(String placeholderName) {
            Object replacement = this.constraint.getConfiguration().get(placeholderName);
            if (replacement == null) {
                return null;
            }
            if (replacement.getClass().isArray()) {
                return org.springframework.util.StringUtils.arrayToDelimitedString((Object[])((Object[])replacement), (String)", ");
            }
            return replacement.toString();
        }
    }
}

