/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.GroupDescriptionResolver;
import capital.scalable.restdocs.constraints.MethodParameterConstraintResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.constraints.Constraint;

class SkippableConstraintResolver
implements MethodParameterConstraintResolver {
    public static final Collection<String> MANDATORY_VALUE_ANNOTATIONS = Arrays.asList("javax.validation.constraints.NotNull", "javax.validation.constraints.NotBlank", "javax.validation.constraints.NotEmpty", "org.hibernate.validator.constraints.NotBlank", "org.hibernate.validator.constraints.NotEmpty");
    private final MethodParameterConstraintResolver delegate;
    private final GroupDescriptionResolver descriptionResolver;

    public SkippableConstraintResolver(MethodParameterConstraintResolver delegate, GroupDescriptionResolver descriptionResolver) {
        this.delegate = delegate;
        this.descriptionResolver = descriptionResolver;
    }

    private boolean isSkippable(Constraint constraint) {
        return MANDATORY_VALUE_ANNOTATIONS.contains(constraint.getName());
    }

    public List<Constraint> resolveForProperty(String property, Class<?> clazz) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : this.delegate.resolveForProperty(property, clazz)) {
            if (this.isSkippable(constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    @Override
    public List<Constraint> resolveForParameter(MethodParameter parameter) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Constraint constraint : this.delegate.resolveForParameter(parameter)) {
            if (this.isSkippable(constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    public List<String> getOptionalMessages(String property, Class<?> clazz) {
        ArrayList<String> result = new ArrayList<String>();
        List constraints = this.delegate.resolveForProperty(property, clazz);
        String defaultOptional = null;
        for (Constraint constraint : constraints) {
            if (!this.isSkippable(constraint)) continue;
            List<Class<?>> groups = this.getGroups(constraint);
            if (groups.isEmpty()) {
                defaultOptional = "false";
                continue;
            }
            for (Class<?> group : groups) {
                result.add(this.mandatoryForGroup(group));
            }
        }
        Collections.sort(result);
        if (defaultOptional != null) {
            result.add(0, defaultOptional);
        }
        return result;
    }

    private List<Class<?>> getGroups(Constraint constraint) {
        return this.descriptionResolver.getGroups(constraint);
    }

    private String mandatoryForGroup(Class group) {
        return this.descriptionResolver.resolveGroupDescription(group, "false");
    }
}

