/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.i18n;

import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleSnippetTranslationResolver
implements SnippetTranslationResolver {
    private ResourceBundle defaultMessages = ResourceBundleSnippetTranslationResolver.getBundle("DefaultSnippetMessages");
    private ResourceBundle userMessages = ResourceBundleSnippetTranslationResolver.getBundle("SnippetMessages");

    private static ResourceBundle getBundle(String name) {
        try {
            return ResourceBundle.getBundle(ResourceBundleSnippetTranslationResolver.class.getPackage().getName() + "." + name, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    @Override
    public String translate(String key, Object ... args) {
        try {
            if (this.userMessages != null) {
                return ResourceBundleSnippetTranslationResolver.format(this.userMessages.getString(key), args);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return ResourceBundleSnippetTranslationResolver.format(this.defaultMessages.getString(key), args);
    }

    void setUserMessages(String name) {
        this.userMessages = ResourceBundleSnippetTranslationResolver.getBundle(name);
    }

    private static String format(String message, Object[] args) {
        return new MessageFormat(message).format(args);
    }
}

