/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.FieldDocumentationArrayVisitor;
import capital.scalable.restdocs.jackson.FieldDocumentationObjectVisitor;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorContext;
import capital.scalable.restdocs.jackson.InternalFieldInfo;
import capital.scalable.restdocs.jackson.TypeRegistry;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.payload.FieldDescriptor;

class FieldDocumentationVisitorWrapper
implements JsonFormatVisitorWrapper {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentationVisitorWrapper.class);
    private SerializerProvider provider;
    private final FieldDocumentationVisitorContext context;
    private final String path;
    private final InternalFieldInfo fieldInfo;
    private final TypeRegistry typeRegistry;
    private final TypeFactory typeFactory;
    private final JsonProperty.Access skipAccessor;

    FieldDocumentationVisitorWrapper(FieldDocumentationVisitorContext context, String path, InternalFieldInfo fieldInfo, TypeRegistry typeRegistry, TypeFactory typeFactory, JsonProperty.Access skipAccessor) {
        this(null, context, path, fieldInfo, typeRegistry, typeFactory, skipAccessor);
    }

    FieldDocumentationVisitorWrapper(SerializerProvider provider, FieldDocumentationVisitorContext context, String path, InternalFieldInfo fieldInfo, TypeRegistry typeRegistry, TypeFactory typeFactory, JsonProperty.Access skipAccessor) {
        this.provider = provider;
        this.context = context;
        this.path = path;
        this.fieldInfo = fieldInfo;
        this.typeRegistry = typeRegistry;
        this.typeFactory = typeFactory;
        this.skipAccessor = skipAccessor;
    }

    public static FieldDocumentationVisitorWrapper create(JavadocReader javadocReader, ConstraintReader constraintReader, DeserializationConfig deserializationConfig, TypeRegistry typeRegistry, TypeFactory typeFactory, SnippetTranslationResolver translationResolver, JsonProperty.Access skipAccessor) {
        FieldDocumentationVisitorContext context = new FieldDocumentationVisitorContext(javadocReader, constraintReader, deserializationConfig, translationResolver);
        return new FieldDocumentationVisitorWrapper(context, "", null, typeRegistry, typeFactory, skipAccessor);
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider provider) {
        this.provider = provider;
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Object");
        if (this.shouldExpand() && (this.topLevelPath() || !this.wasVisited(type))) {
            log.trace("({}) {} expanding", (Object)this.path, (Object)this.toString(type));
            return new FieldDocumentationObjectVisitor(this.provider, this.context, this.path, this.withVisitedType(type), this.typeFactory, this.skipAccessor);
        }
        log.trace("({}) {} NOT expanding", (Object)this.path, (Object)this.toString(type));
        return new JsonObjectFormatVisitor.Base();
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType arrayType) throws JsonMappingException {
        JavaType contentType = arrayType.getContentType();
        this.addFieldIfPresent(TypeUtil.determineArrayOfType(contentType));
        if (contentType != null && this.shouldExpand() && (this.topLevelPath() || !this.wasVisited(contentType))) {
            log.trace("({}) {} expanding array", (Object)this.path, (Object)this.toString(contentType));
            return new FieldDocumentationArrayVisitor(this.provider, this.context, this.path, this.typeRegistry, this.typeFactory, this.skipAccessor);
        }
        log.trace("({}) {} NOT expanding array", (Object)this.path, (Object)"<unknown>");
        return new JsonArrayFormatVisitor.Base();
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("String");
        return new JsonStringFormatVisitor.Base();
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Decimal");
        return new JsonNumberFormatVisitor.Base();
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Integer");
        return new JsonIntegerFormatVisitor.Base();
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Boolean");
        return new JsonBooleanFormatVisitor.Base();
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("null");
        return new JsonNullFormatVisitor.Base();
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Object");
        return new JsonAnyFormatVisitor.Base();
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType type) throws JsonMappingException {
        this.addFieldIfPresent("Map");
        return new JsonMapFormatVisitor.Base(this.provider);
    }

    public List<FieldDescriptor> getFields() {
        return this.context.getFields();
    }

    private void addFieldIfPresent(String jsonType) {
        if (this.fieldInfo != null) {
            this.context.addField(this.fieldInfo, jsonType);
        }
    }

    private boolean shouldExpand() {
        return this.fieldInfo == null || this.fieldInfo.shouldExpand();
    }

    private TypeRegistry withVisitedType(JavaType javaType) {
        List<JavaType> allTypes = TypeUtil.resolveAllTypes(javaType, this.typeFactory, this.typeRegistry.getTypeMapping());
        return this.typeRegistry.withVisitedTypes(allTypes);
    }

    private boolean wasVisited(JavaType type) {
        return this.typeRegistry.wasVisited(type);
    }

    private boolean topLevelPath() {
        return "".equals(this.path);
    }

    private String toString(JavaType type) {
        return type.getRawClass().getSimpleName();
    }
}

