/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.constraints.ConstraintReaderImpl;
import capital.scalable.restdocs.constraints.DynamicResourceBundleConstraintDescriptionResolver;
import capital.scalable.restdocs.i18n.SnippetTranslationManager;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.SardObjectMapper;
import capital.scalable.restdocs.jackson.TypeMapping;
import capital.scalable.restdocs.javadoc.JavadocReaderImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.web.method.HandlerMethod;

public abstract class JacksonResultHandlers {
    public static ResultHandler prepareJackson(ObjectMapper objectMapper) {
        return new JacksonPreparingResultHandler(objectMapper, new TypeMapping(), SnippetTranslationManager.getDefaultResolver(), new DynamicResourceBundleConstraintDescriptionResolver());
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, SnippetTranslationResolver translationResolver) {
        return new JacksonPreparingResultHandler(objectMapper, new TypeMapping(), translationResolver, new DynamicResourceBundleConstraintDescriptionResolver());
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, TypeMapping typeMapping) {
        return new JacksonPreparingResultHandler(objectMapper, typeMapping, SnippetTranslationManager.getDefaultResolver(), new DynamicResourceBundleConstraintDescriptionResolver());
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, ConstraintDescriptionResolver constraintDescriptionResolver) {
        return new JacksonPreparingResultHandler(objectMapper, new TypeMapping(), SnippetTranslationManager.getDefaultResolver(), constraintDescriptionResolver);
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, TypeMapping typeMapping, SnippetTranslationResolver translationResolver) {
        return new JacksonPreparingResultHandler(objectMapper, typeMapping, translationResolver, new DynamicResourceBundleConstraintDescriptionResolver());
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, SnippetTranslationResolver translationResolver, ConstraintDescriptionResolver constraintDescriptionResolver) {
        return new JacksonPreparingResultHandler(objectMapper, new TypeMapping(), translationResolver, constraintDescriptionResolver);
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, TypeMapping typeMapping, ConstraintDescriptionResolver constraintDescriptionResolver) {
        return new JacksonPreparingResultHandler(objectMapper, typeMapping, SnippetTranslationManager.getDefaultResolver(), constraintDescriptionResolver);
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, TypeMapping typeMapping, SnippetTranslationResolver translationResolver, ConstraintDescriptionResolver constraintDescriptionResolver) {
        return new JacksonPreparingResultHandler(objectMapper, typeMapping, translationResolver, constraintDescriptionResolver);
    }

    private static class JacksonPreparingResultHandler
    implements ResultHandler {
        private final ObjectMapper objectMapper;
        private final TypeMapping typeMapping;
        private final SnippetTranslationResolver translationResolver;
        private final ConstraintDescriptionResolver constraintDescriptionResolver;

        public JacksonPreparingResultHandler(ObjectMapper objectMapper, TypeMapping typeMapping, SnippetTranslationResolver translationResolver, ConstraintDescriptionResolver constraintDescriptionResolver) {
            this.objectMapper = new SardObjectMapper(objectMapper);
            this.typeMapping = typeMapping;
            this.translationResolver = translationResolver;
            this.constraintDescriptionResolver = constraintDescriptionResolver;
        }

        public void handle(MvcResult result) throws Exception {
            if (result.getHandler() instanceof HandlerMethod) {
                OperationAttributeHelper.setHandlerMethod(result.getRequest(), (HandlerMethod)result.getHandler());
            }
            OperationAttributeHelper.setObjectMapper(result.getRequest(), this.objectMapper);
            OperationAttributeHelper.initRequestPattern(result.getRequest());
            OperationAttributeHelper.setJavadocReader(result.getRequest(), JavadocReaderImpl.createWithSystemProperty());
            OperationAttributeHelper.setConstraintReader(result.getRequest(), ConstraintReaderImpl.create(this.objectMapper, this.translationResolver, this.constraintDescriptionResolver));
            OperationAttributeHelper.setTypeMapping(result.getRequest(), this.typeMapping);
        }
    }
}

