/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.section;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.SnippetRegistry;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.section.SectionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.RestDocumentationContextPlaceholderResolverFactory;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;

public class SectionSnippet
extends TemplatedSnippet {
    private static final Logger log = LoggerFactory.getLogger(SectionSnippet.class);
    public static final String SECTION = "auto-section";
    protected final RestDocumentationContextPlaceholderResolverFactory placeholderResolverFactory = new RestDocumentationContextPlaceholderResolverFactory();
    protected final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");
    protected final Collection<String> sectionNames;
    protected final boolean skipEmpty;

    public SectionSnippet(Collection<String> sectionNames, boolean skipEmpty) {
        super(SECTION, null);
        this.sectionNames = sectionNames;
        this.skipEmpty = skipEmpty;
    }

    protected Map<String, Object> createModel(Operation operation) {
        Map<String, Object> model = this.defaultModel(operation);
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        if (handlerMethod == null) {
            return model;
        }
        JavadocReader javadocReader = OperationAttributeHelper.getJavadocReader(operation);
        SnippetTranslationResolver translationResolver = OperationAttributeHelper.getTranslationResolver(operation);
        String title = this.resolveTitle(handlerMethod, javadocReader, translationResolver);
        model.put("title", title);
        model.put("sections", this.createSections(operation, translationResolver));
        return model;
    }

    protected Collection<Section> createSections(Operation operation, SnippetTranslationResolver translationResolver) {
        ArrayList<Section> sections = new ArrayList<Section>();
        for (String sectionName : this.sectionNames) {
            SectionSupport section = this.getSectionSnippet(operation, sectionName);
            if (section != null) {
                boolean hasContent = section.hasContent(operation);
                if (this.skipEmpty && !hasContent) continue;
                String header = translationResolver.translate(section.getHeaderKey(operation), new Object[0]);
                Optional<Section> toAdd = sections.stream().filter(s -> s.header.equals(header)).findFirst();
                if (section.isMergeable() && toAdd.isPresent()) {
                    toAdd.get().addSection(section.getFileName(), hasContent);
                    continue;
                }
                sections.add(new Section(header, section.getFileName(), hasContent));
                continue;
            }
            log.warn("Section snippet '" + sectionName + "' is configured to be included in the section but no such snippet is present in configuration");
        }
        return sections;
    }

    private Map<String, Object> defaultModel(Operation operation) {
        String path = this.propertyPlaceholderHelper.replacePlaceholders(operation.getName(), this.placeholderResolverFactory.create(OperationAttributeHelper.getDocumentationContext(operation)));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("title", this.createTitle(operation.getName()));
        model.put("link", this.delimit(path));
        model.put("path", path);
        model.put("sections", Collections.emptyList());
        return model;
    }

    protected String resolveTitle(HandlerMethod handlerMethod, JavadocReader javadocReader, SnippetTranslationResolver translationResolver) {
        String title = javadocReader.resolveMethodTag(handlerMethod.getBeanType(), handlerMethod.getMethod().getName(), "title");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)title)) {
            title = this.createTitle(handlerMethod.getMethod().getName());
        }
        boolean isDeprecated = handlerMethod.getMethod().getAnnotation(Deprecated.class) != null;
        String deprecated = javadocReader.resolveMethodTag(handlerMethod.getBeanType(), handlerMethod.getMethod().getName(), "deprecated");
        if (isDeprecated || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)deprecated)) {
            return translationResolver.translate("tags-deprecated-title", title);
        }
        return title;
    }

    private String createTitle(String name) {
        return org.apache.commons.lang3.StringUtils.join((Object[])org.apache.commons.lang3.StringUtils.splitByCharacterTypeCamelCase((String)StringUtils.capitalize((String)name)), (char)' ');
    }

    private SectionSupport getSectionSnippet(Operation operation, String snippetName) {
        return OperationAttributeHelper.getDefaultSnippets(operation).stream().filter(snippet -> snippet instanceof SectionSupport).map(snippet -> (SectionSupport)snippet).filter(snippet -> snippetName.equals(snippet.getFileName())).findFirst().orElseGet(() -> SnippetRegistry.getClassicSnippet(snippetName));
    }

    private String delimit(String value) {
        return value.replace("/", "-");
    }

    static class Section {
        String header;
        List<String> filenames;
        boolean hasContent;

        public Section(String header, String filename, boolean hasContent) {
            this.header = header;
            this.filenames = new ArrayList<String>(Collections.singletonList(filename));
            this.hasContent = hasContent;
        }

        void addSection(String filename, boolean hasContent) {
            if (!hasContent) {
                return;
            }
            if (!this.hasContent) {
                this.hasContent = hasContent;
                this.filenames = new ArrayList<String>(Collections.singletonList(filename));
            } else {
                this.hasContent = hasContent;
                this.filenames.add(filename);
            }
        }
    }
}

