/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.snippet;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.DeprecatedAttribute;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.javadoc.JavadocUtil;
import capital.scalable.restdocs.util.FormatUtil;
import capital.scalable.restdocs.util.TemplateFormatting;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.web.method.HandlerMethod;

public abstract class StandardTableSnippet
extends TemplatedSnippet {
    protected StandardTableSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    protected Map<String, Object> createModel(Operation operation) {
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        SnippetTranslationResolver translationResolver = OperationAttributeHelper.getTranslationResolver(operation);
        Map<String, Object> model = this.defaultModel(translationResolver);
        if (handlerMethod == null) {
            return model;
        }
        FieldDescriptors fieldDescriptors = this.createFieldDescriptors(operation, handlerMethod);
        TemplateFormatting templateFormatting = OperationAttributeHelper.determineTemplateFormatting(operation);
        return this.createModel(handlerMethod, model, fieldDescriptors, templateFormatting, translationResolver);
    }

    protected abstract FieldDescriptors createFieldDescriptors(Operation var1, HandlerMethod var2);

    protected abstract String[] getTranslationKeys();

    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod, FieldDescriptors fieldDescriptors, SnippetTranslationResolver translationResolver) {
    }

    private Map<String, Object> createModel(HandlerMethod handlerMethod, Map<String, Object> model, FieldDescriptors fieldDescriptors, TemplateFormatting templateFormatting, SnippetTranslationResolver translationResolver) {
        Collection<FieldDescriptor> fields = fieldDescriptors.values();
        List content = fields.stream().map(descriptor -> this.createModelForDescriptor((FieldDescriptor)descriptor, templateFormatting, translationResolver)).collect(Collectors.toList());
        model.put("content", content);
        model.put("hasContent", !fields.isEmpty());
        model.put("noContent", fields.isEmpty());
        this.enrichModel(model, handlerMethod, fieldDescriptors, translationResolver);
        return model;
    }

    private Map<String, Object> defaultModel(SnippetTranslationResolver translationResolver) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        for (String key : this.getTranslationKeys()) {
            model.put(key, translationResolver.translate(key, new Object[0]));
        }
        model.put("content", "");
        model.put("hasContent", false);
        model.put("noContent", true);
        return model;
    }

    protected Map<String, Object> createModelForDescriptor(FieldDescriptor descriptor, TemplateFormatting templateFormatting, SnippetTranslationResolver translationResolver) {
        String path = descriptor.getPath();
        String type = this.toString(descriptor.getType());
        String methodComment = this.resolveComment(descriptor);
        String deprecatedComment = this.resolveDeprecated(descriptor, translationResolver);
        String completeComment = FormatUtil.join("<p>", deprecatedComment, methodComment);
        String description = JavadocUtil.convertFromJavadoc(completeComment, templateFormatting);
        String optional = this.resolveOptional(descriptor, templateFormatting);
        List<String> constraints = this.resolveConstraints(descriptor);
        String defaultValue = this.resolveDefaultValue(descriptor, translationResolver);
        description = this.joinAndFormat(description, constraints, defaultValue, templateFormatting);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", path);
        model.put("type", type);
        model.put("optional", optional);
        model.put("description", description);
        return model;
    }

    private String defaultValuePrefix(String description) {
        return StringUtils.isEmpty((CharSequence)description) ? "" : "\n\n";
    }

    private List<String> resolveConstraints(FieldDescriptor descriptor) {
        return (List)descriptor.getAttributes().get("constraints");
    }

    private String resolveOptional(FieldDescriptor descriptor, TemplateFormatting templateFormatting) {
        List optionalMessages = (List)descriptor.getAttributes().get("optionals");
        return "" + FormatUtil.join(templateFormatting.getLineBreak(), optionalMessages.toArray());
    }

    private String resolveComment(FieldDescriptor descriptor) {
        return StringUtils.capitalize((String)FormatUtil.addDot(this.toString(descriptor.getDescription())));
    }

    private String resolveDeprecated(FieldDescriptor descriptor, SnippetTranslationResolver translationResolver) {
        DeprecatedAttribute deprecated = (DeprecatedAttribute)descriptor.getAttributes().get("deprecated");
        if (deprecated != null && deprecated.isDeprecated()) {
            return FormatUtil.addDot(translationResolver.translate("tags-deprecated", StringUtils.capitalize((String)StringUtils.join(deprecated.getValues(), (String)". "))));
        }
        return "";
    }

    private String resolveDefaultValue(FieldDescriptor descriptor, SnippetTranslationResolver translationResolver) {
        String defaultValue = this.toString(descriptor.getAttributes().get("default-value"));
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            return FormatUtil.addDot(translationResolver.translate("default-value", defaultValue));
        }
        return "";
    }

    private String toString(Object value) {
        if (value != null) {
            return StringUtils.trimToEmpty((String)value.toString());
        }
        return "";
    }

    private String joinAndFormat(String description, List<String> constraints, String defaultValue, TemplateFormatting templateFormatting) {
        StringBuilder res = new StringBuilder(description);
        if (!description.isEmpty() && !description.endsWith(".")) {
            res.append('.');
        }
        StringBuilder constr = this.formatConstraints(constraints, templateFormatting.getLineBreak());
        if (res.length() > 0 && constr.length() > 0) {
            res.append("\n\n");
        }
        res.append(constr.toString());
        if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            res.append(this.defaultValuePrefix(description)).append(defaultValue);
        }
        return res.toString().replace("|", "\\|");
    }

    private StringBuilder formatConstraints(List<String> constraints, String forcedLineBreak) {
        StringBuilder res = new StringBuilder();
        for (String constraint : constraints) {
            if (constraint.trim().isEmpty()) continue;
            if (res.length() > 0) {
                res.append(forcedLineBreak);
            }
            res.append(constraint.trim());
            if (constraint.endsWith(".")) continue;
            res.append('.');
        }
        return res;
    }
}

